<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller {

	public function __construct() {
        parent::__construct();
        $this->load->library(array('session', 'form_validation'));
        $this->load->helper(array('url', 'html'));
        $this->load->model('Index_Model');

        if (!$this->session->userdata('logged_in')) {
            redirect('/login');
        }
    }

	function index()
	{
		$this->load->view('dashboard/mainnavigator');
	}
	
    function dash()
    {
        $data['dash'] = $this->Index_Model->get_dashboard();
        $data['pending_actions'] = $this->Index_Model->get_my_pending_actions();
        $data['activity'] = $this->Index_Model->get_my_activity_log();
        $data['repayments'] = $this->BorrowersModel->get_my_upcoming_repayments();
        $data['clients'] = $this->BorrowersModel->get_my_clients();
        $this->load->view('dashboard/dash',$data); 
    }
    
}

