<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Loan extends CI_Controller {

	public function index()
	{
	}

	public function sViewAllLoans(){
		$data['loantypes'] = $this->BorrowersModel->getloanTypes();
		$data['branches'] = $this->BorrowersModel->getBranches();
		$data['officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['status'] = $this->BorrowersModel->get_loan_status();

		$this->load->view('loans/viewallloans',$data);  
	}
	 
	public function sViewAddLoans(){
		$data['loanTypes'] = $this->BorrowersModel->getloanTypes();
		$data['clients'] = $this->BorrowersModel->getClients_();
		$data['loan_officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['branches'] = $this->BorrowersModel->getBranches();
		$data['borrower'] = $this->input->post('id');

		$this->load->view('loans/addloans',$data);
	}
	
	public function due_loans(){
		$data['loantypes'] = $this->BorrowersModel->getloanTypes();
		$data['branches'] = $this->BorrowersModel->getBranches();
		$data['officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['status'] = $this->BorrowersModel->get_loan_status();

		$this->load->view('loans/dueloans',$data);
	}

	public function active_loans(){
		$data['loantypes'] = $this->BorrowersModel->getloanTypes();
		$data['branches'] = $this->BorrowersModel->getBranches();
		$data['officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['status'] = $this->BorrowersModel->get_loan_status();

		$this->load->view('loans/activeloans',$data);
	}

	public function arrears_loans(){

		$data['loantypes'] = $this->BorrowersModel->getloanTypes();
		$data['branches'] = $this->BorrowersModel->getBranches();
		$data['officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['status'] = $this->BorrowersModel->get_loan_status();

		$this->load->view('loans/arrearsloans',$data);
	}

	public function pending_loans()
	{
		$data['loantypes'] = $this->BorrowersModel->getloanTypes();
		$data['branches'] = $this->BorrowersModel->getBranches();
		$data['officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['status'] = $this->BorrowersModel->get_loan_status();

		$this->load->view('loans/pendingloans',$data);
	}

	public function rejected_loans()
	{
		$data['loantypes'] = $this->BorrowersModel->getloanTypes();
		$data['branches'] = $this->BorrowersModel->getBranches();
		$data['officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['status'] = $this->BorrowersModel->get_loan_status();

		$this->load->view('loans/rejectedloans',$data);
	}

	public function fully_paid()
	{
		$data['loantypes'] = $this->BorrowersModel->getloanTypes();
		$data['branches'] = $this->BorrowersModel->getBranches();
		$data['officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['status'] = $this->BorrowersModel->get_loan_status();

		$this->load->view('loans/fullypaid',$data);
	}
	

	public function sMissedRepayment(){
		$data['loantypes'] = $this->BorrowersModel->getloanTypes();
		$data['branches'] = $this->BorrowersModel->getBranches();
		$data['officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['status'] = $this->BorrowersModel->get_loan_status();

		$this->load->view('loans/missedrepayments',$data);
	}

	public function sPastaturityDate(){
		$data['loantypes'] = $this->BorrowersModel->getloanTypes();
		$data['branches'] = $this->BorrowersModel->getBranches();
		$data['officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['status'] = $this->BorrowersModel->get_loan_status();

		$this->load->view('loans/pastmaturitydate',$data);
	}

	public function sOneMonthLate(){
		$data['loantypes'] = $this->BorrowersModel->getloanTypes();
		$data['branches'] = $this->BorrowersModel->getBranches();
		$data['officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['status'] = $this->BorrowersModel->get_loan_status();

		$this->load->view('loans/onemonthlate',$data);
	}

	public function sThreeMonthsLate(){
		$this->load->view('loans/threemonthlate');
	}

	public function sLoanCalculator(){
		$this->load->view('loans/loancalculator');
	}

    public function sGuarantors(){
		$this->load->view('loans/guarantors');
	}

	public function schedule()
	{
		$loan_ref = $this->input->post('loan_ref');

		$data['loan'] = $this->BorrowersModel->get_loan_master($loan_ref);
		$data['schedule'] = $this->BorrowersModel->get_loan_schedule($loan_ref);

		$this->load->view('loans/get/schedule',$data);
	}

	public function approve_loan()
	{
		$loan_ref = $this->input->post('loan_ref');
		$data['loan'] = $this->BorrowersModel->get_loan_record($loan_ref);
		$data['reasons'] = $this->BorrowersModel->get_approval_reasons();
		$this->load->view('loans/approve',$data);
	}

	public function edit_loan()
	{
		$loan_ref = $this->input->post('id');
		$data['loan'] = $this->BorrowersModel->get_loan_record($loan_ref);
		$data['reasons'] = $this->BorrowersModel->get_approval_reasons();
		$data['borrower'] = $this->BorrowersModel->get_borrower_id_from_loan_ref($loan_ref);
		$data['loanTypes'] = $this->BorrowersModel->getloanTypes();
		$data['loanTypes_'] = $this->BorrowersModel->getloanTypes_();
		$data['clients'] = $this->BorrowersModel->getClients_();
		$data['loan_officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['branches'] = $this->BorrowersModel->getBranches();
		#$data['borrower'] = $this->input->post('id');
		$this->load->view('client/edit_loan',$data);
	}

	public function update_loan()
	{
		echo $this->BorrowersModel->update_loan($this->input->post('loan'));
	}

	public function reverse_loan()
	{
		$loan_ref = $this->input->post('loan_ref');
		$reason = $this->input->post('reason');

		echo $this->BorrowersModel->reverse_loan($loan_ref,$reason);
	}
}

