<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Printer extends CI_Controller {

	public function index()
	{

	}

	public function schedule()
	{
		$loan_ref = $this->input->post('loan_ref');
		$mode = $this->input->post('mode');

		$data['borrower'] = $this->BorrowersModel->get_loan_borrower($loan_ref);
		$data['loan'] = $this->BorrowersModel->get_loan_master($loan_ref);
		$data['schedule'] = $this->BorrowersModel->get_loan_schedule($loan_ref);

		if ($mode == 'PDF') {
			$html = $this->load->view('print/schedule',$data,true);
			$pdfFilePath = "schedule.pdf";
			$mpdf = new \Mpdf\mPDF();
			$mpdf->WriteHTML($html);
			$mpdf->Output();
		} else if ($mode == 'EXCEL') {
			$this->load->helper('download');
            $data = $this->BorrowersModel->get_loan_schedule_excel($loan_ref);
            $name = 'schedule.csv';
            force_download($name,$data);
		} else if ($mode == 'CSV') {
			$this->load->helper('download');
            $data = $this->BorrowersModel->get_loan_schedule_excel($loan_ref);
            $name = 'schedule.csv';
            force_download($name,$data);
		} else {
			$this->load->view('print/schedule',$data);
		}
	}

	public function print_loan_statement()
	{
		$loan_ref = $this->input->post('loan_ref');
		$data['statement'] = $this->ReportModel->get_loan_statement($loan_ref);
		$data['loan'] = $this->ReportModel->get_loan_master($loan_ref);
		$data['report_title'] = $loan_ref;
		$this->load->view('print/loan_statement',$data);
	}

	public function pdf_loan_statement()
	{
		$loan_ref = $this->input->post('loan_ref');
		$data['statement'] = $this->ReportModel->get_loan_statement($loan_ref);
		$data['loan'] = $this->ReportModel->get_loan_master($loan_ref);
		$data['report_title'] = $loan_ref;
		$html = $this->load->view('print/loan_statement',$data,true);
		$pdfFilePath = "loan_statement.pdf";
		$mpdf = new \Mpdf\mPDF();
		$mpdf->WriteHTML($html);
		$mpdf->Output();
	}

	public function excel_loan_statement()
	{
		$this->load->helper('download');
		$loan_ref = $this->input->post('loan_ref');
		$data = $this->ReportModel->get_loan_statement_excel($loan_ref);
        $name = 'loan_statement_'.$loan_ref.'.csv';
        force_download($name,$data);
	}
	
}

?>
