<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Repayments extends CI_Controller {

	public function index()
	{

	}

	public function sViewRepayments()
	{
		$data['loantypes'] = $this->BorrowersModel->getloanTypes();
		$data['clients'] = $this->BorrowersModel->getClients_();
		$data['officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['branches'] = $this->BorrowersModel->getBranches();
   
		$this->load->view('repayments/viewrepayments',$data);
	}
	
	public function sAddBulkRep()
	{
		$this->load->view('repayments/addbulkrepayments');
	}
	 
	public function sUploadRepaymentFromCsv()
	{
		$this->load->view('repayments/uploadrepaymentsfromcsv');
	}

	public function repayments_list_()
	{ 
		function status($id='')
		{
			$str = '
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-olive margin-right" href="#" id="client_loans" idx="'.$id.'">Loans</a>
	            </div>
            ';
            
			return $str;
		}

		function posted($status='',$ref='')
		{
			$str = '';
			if ($status == 0) {
				$str = '
					<div class="btn-group-horizontal">
		                <a type="button" class="btn-xs bg-olive margin-right" href="#" id="id_post_repayment" ref="'.$ref.'">Post</a>
		            </div>
					<div class="btn-group-horizontal">
		                <a type="button" class="btn-xs bg-red margin-right" href="#" id="id_reverse_repayment" ref="'.$ref.'">Reverse</a>
		            </div>
	            ';
			} else if ($status == 1) {
				$str = 'Posted
					<div class="btn-group-horizontal">
		                <a type="button" class="btn-xs bg-red margin-right" href="#" id="id_reverse_repayment" ref="'.$ref.'">Reverse</a>
		            </div>
	            ';
	            return $str;
			} else if ($status == 9) {
				return 'Reversed';
			} else {
				return 'Pending';
			}

			return $str;
		}

		$requestData = $_REQUEST;

		$query = $this->BorrowersModel->get_repayments_list_($requestData,$totalData,$totalFiltered,0,$total,$balance);

		$data = array();
		foreach ($query as $q) {
			$nesteborrowerid = array();
			$nesteborrowerid[] = $q->id;
			$nesteborrowerid[] = $q->ref;
			#$nesteborrowerid[] = $q->loan_ref;
			#$nesteborrowerid[] = status($q->loan_ref);
			$nesteborrowerid[] = posted($q->status,$q->ref);
			$nesteborrowerid[] = $q->loan_type;
			$nesteborrowerid[] = $q->name;
			$nesteborrowerid[] = $q->amount;
			$nesteborrowerid[] = $q->tran_type;
			$nesteborrowerid[] = $q->tran_ref;
			$nesteborrowerid[] = $q->loan_officer;
			$nesteborrowerid[] = $q->branch;
			$nesteborrowerid[] = date('d/m/y',strtotime($q->pdate));
			$nesteborrowerid[] = number_format($q->amount);
			$nesteborrowerid[] = number_format($q->balance);
			$nesteborrowerid[] = date('d/m/y',strtotime($q->nextduedate));
			
			$data[] = $nesteborrowerid;
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data,   
			"total"	  => 'Kshs '.number_format($total),
			"balance"	  => 'Kshs '.number_format($balance)
		);

		echo json_encode($json_data);

	}

	public function repayment()
	{
		$data['clients'] = $this->BorrowersModel->getClients_();
		$data['loan_officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['branches'] = $this->BorrowersModel->getBranches();
		$data['borrower'] = $this->input->post('id');
		
		$this->load->view('repayments/repayment',$data);
	}

	public function add_repayment()
	{
		$loan = $this->input->post('loan');
		parse_str($loan,$repayment);
		echo $this->BorrowersModel->add_repayment($repayment);
	}

	public function post_repayment()
	{
		$ref = $this->input->post('ref');
		$remarks = $this->input->post('remarks');
		$date = date('Y-m-d');

		echo $this->BorrowersModel->post_repayment($ref,$remarks,$date);
	}

	public function reverse_repayment()
	{
		$ref = $this->input->post('ref');
		$remarks = $this->input->post('remarks');
		$date = date('Y-m-d');

		echo $this->BorrowersModel->reverse_repayment($ref,$remarks,$date);
	}

	public function posted_list()
	{
		$data['loantypes'] = $this->BorrowersModel->getloanTypes();
		$data['clients'] = $this->BorrowersModel->getClients_();
		$data['officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['branches'] = $this->BorrowersModel->getBranches();

		$this->load->view('repayments/posted_list',$data); 
	}
	
	public function reversed_list()
	{
		$data['loantypes'] = $this->BorrowersModel->getloanTypes();
		$data['clients'] = $this->BorrowersModel->getClients_();
		$data['officers'] = $this->BorrowersModel->getLoanOfficers();
		$data['branches'] = $this->BorrowersModel->getBranches();

		$this->load->view('repayments/reversed_list',$data);
	}
	
	public function posted_list_()
	{
		function status($id='')
		{
			$str = '
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-olive margin-right" href="#" id="client_loans" idx="'.$id.'">Loans</a>
	            </div>
            ';
            
			return $str;
		}

		function posted($status='',$ref='')
		{
			$str = '';
			if ($status == 0) {
				$str = '
					<div class="btn-group-horizontal">
		                <a type="button" class="btn-xs bg-olive margin-right" href="#" id="id_post_repayment" ref="'.$ref.'">Unposted</a>
		            </div>
	            ';
			} else if ($status == 1) {
				$str = 'Posted
					<div class="btn-group-horizontal">
		                <a type="button" class="btn-xs bg-red margin-right" href="#" id="id_reverse_repayment" ref="'.$ref.'">Reverse</a>
		            </div>
	            ';
	            return $str;
			} else if ($status == 9) {
				return 'Reversed';
			} else {
				return 'Pending';
			}

			return $str;
		}

		$requestData = $_REQUEST;

		$query = $this->BorrowersModel->get_repayments_list_($requestData,$totalData,$totalFiltered,1,$total,$balance);

		$data = array();
		foreach ($query as $q) {
			$nesteborrowerid = array();
			$nesteborrowerid[] = $q->id;
			$nesteborrowerid[] = $q->ref;
			#$nesteborrowerid[] = $q->loan_ref;
			#$nesteborrowerid[] = status($q->loan_ref);
			$nesteborrowerid[] = posted($q->status,$q->ref);
			$nesteborrowerid[] = $q->loan_type;
			$nesteborrowerid[] = $q->name;
			$nesteborrowerid[] = $q->amount;
			$nesteborrowerid[] = $q->tran_type;
			$nesteborrowerid[] = $q->tran_ref;
			$nesteborrowerid[] = $q->loan_officer;
			$nesteborrowerid[] = $q->branch;
			$nesteborrowerid[] = date('d/m/y',strtotime($q->pdate));
			$nesteborrowerid[] = number_format($q->amount);
			$nesteborrowerid[] = number_format($q->balance);
			$nesteborrowerid[] = date('d/m/y',strtotime($q->nextduedate));
			
			$data[] = $nesteborrowerid;
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data,   
			"total"	  => 'Kshs '.number_format($total),
			"balance"	  => 'Kshs '.number_format($balance)
		);

		echo json_encode($json_data);

	}
	public function reversed_list_()
	{
		function status($id='')
		{
			$str = '
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-olive margin-right" href="#" id="client_loans" idx="'.$id.'">Loans</a>
	            </div>
            ';
            
			return $str;
		}

		function posted($status='',$ref='')
		{
			$str = '';
			if ($status == 0) {
				$str = '
					<div class="btn-group-horizontal">
		                <a type="button" class="btn-xs bg-olive margin-right" href="#" id="id_post_repayment" ref="'.$ref.'">Unposted</a>
		            </div>
	            ';
			} else if ($status == 1) {
				return 'Posted';
			} else if ($status == 9) {
				return 'Reversed';
			} else {
				return 'Pending';
			}

			return $str;
		}

		$requestData = $_REQUEST;

		$query = $this->BorrowersModel->get_repayments_list_($requestData,$totalData,$totalFiltered,9,$total,$balance);

		$data = array();
		foreach ($query as $q) {
			$nesteborrowerid = array();
			$nesteborrowerid[] = $q->id;
			$nesteborrowerid[] = $q->ref;
			#$nesteborrowerid[] = $q->loan_ref;
			#$nesteborrowerid[] = status($q->loan_ref);
			$nesteborrowerid[] = posted($q->status,$q->ref);
			$nesteborrowerid[] = $q->loan_type;
			$nesteborrowerid[] = $q->name;
			$nesteborrowerid[] = $q->amount;
			$nesteborrowerid[] = $q->tran_type;
			$nesteborrowerid[] = $q->tran_ref;
			$nesteborrowerid[] = $q->loan_officer;
			$nesteborrowerid[] = $q->branch;
			$nesteborrowerid[] = date('d/m/y',strtotime($q->pdate));
			$nesteborrowerid[] = number_format($q->amount);
			/*$nesteborrowerid[] = number_format($q->balance);*/
			$nesteborrowerid[] = date('d/m/y',strtotime($q->nextduedate));
			
			$data[] = $nesteborrowerid;
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data,   
			"total"	  => 'Kshs '.number_format($total),
			"balance"	  => 'Kshs '.number_format($balance)
		);

		echo json_encode($json_data);

	}
	
	public function mpesa_payments()
	{
		$data = array();
		$this->load->view('repayments/mpesa_payments',$data); 
	}

	public function mpesa_payments_list_()
	{
		function status($id='')
		{
			$str = '
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-olive margin-right" href="#" id="client_loans" idx="'.$id.'">Loans</a>
	            </div>
            ';
            
			return $str;
		}

		function posted($status='',$ref='')
		{
			$str = '';
			if ($status == 0) {
				$str = '
					<div class="btn-group-horizontal">
		                <a type="button" class="btn-xs bg-olive margin-right" href="#" id="id_post_repayment" ref="'.$ref.'">Unposted</a>
		            </div>
	            ';
			} else if ($status == 1) {
				return 'Posted';
			} else if ($status == 9) {
				return 'Reversed';
			} else {
				return 'Pending';
			}

			return $str;
		}

		$requestData = $_REQUEST;

		$query = $this->BorrowersModel->get_mpesa_payments_list_($requestData,$totalData,$totalFiltered,0,$total,$balance);

		$data = array();
		foreach ($query as $q) {
			$mpesa = array();
			$mpesa[] = $q->id;
			$mpesa[] = $q->TransactionType;
			$mpesa[] = $q->TransID;
			$mpesa[] = $q->TransTime;
			$mpesa[] = $q->BusinessShortCode;
			$mpesa[] = $q->MSISDN;
			$mpesa[] = ($q->First_Name.' '.$q->Middle_Name.' '.$q->Last_Name);
			$mpesa[] = $q->TransAmount;
			$mpesa[] = $q->OrgAccountBalance;
			$mpesa[] = ($q->posted=='1'?'YES':'NO');
			$mpesa[] = $q->receipt_ref;
			
			$data[] = $mpesa;
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data,   
			"total"	  => 'Kshs '.number_format($total),
			"balance"	  => 'Kshs '.number_format($balance)
		);

		echo json_encode($json_data);

	}
	


}

