<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Settings extends CI_Controller {


	public function index()
	{
	}

	public function branches(){
		$this->load->view('settings/branches'); 
	}

	function branches_list_()
	{
		function status($id='',$status=0)
		{
			$str = '
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-green margin-right" href="#" id="view_branch" idx="'.$id.'">'.$status.'</a>
	            </div>
            ';
            
			return $str;
		} 

		function actions($id='')
		{
			$str = ' 
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-blue margin-right" href="#" id="edit_branch" idx="'.$id.'">Edit</a>
	                <a type="button" class="btn-xs bg-red" href="#" id="delete_branch" idx="'.$id.'">Delete</a>
	            </div>
            ';
            
			return $str;
		}

		$requestData = $_REQUEST;

		$query = $this->SettingsModel->get_branches_($requestData,$totalData,$totalFiltered);

		$data = array();
		foreach ($query as $q) {
			$branches = array(); 

			$branches[] = $q->id;
			$branches[] = $q->code;
			$branches[] = $q->description;
			$branches[] = $q->telephone;
			$branches[] = $q->loanofficers;
			$branches[] = $q->loanportfolio;
			$branches[] = $q->accounts;
			$branches[] = status($q->id,$q->status); 
			$branches[] = actions($q->id); 
			
			$data[] = $branches;
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data   
		);

		echo json_encode($json_data);		
	}

	function loanTypes(){
		$this->load->view('settings/loanTypes'); 
	}

	function loan_types_list_()
	{
		function status($id='',$status=0)
		{
			if ($status == '1') {
				$stat = 'Active';
			} else {
				$stat = 'Inactive';
			}

			$str = '
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-green margin-right" href="#" id="view_loan_type" idx="'.$id.'">'.$stat.'</a>
	            </div>
            ';
            
			return $str;
		} 

		function actions($id='')
		{
			$str = ' 
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-blue margin-right" href="#" id="edit_loan_type" idx="'.$id.'">Edit</a>
	                <a type="button" class="btn-xs bg-red" href="#" id="delete_loan_type" idx="'.$id.'">Delete</a>
	            </div>
            ';
            
			return $str;
		}

		$requestData = $_REQUEST;

		$query = $this->SettingsModel->get_loan_types_($requestData,$totalData,$totalFiltered);

		$data = array();
		foreach ($query as $q) {
			$loanTypes = array(); 

			$loanTypes[] = $q->id;
			$loanTypes[] = $q->code;
			$loanTypes[] = $q->name;
			$loanTypes[] = $q->interest_rate;
			$loanTypes[] = $q->processing_rate;
			$loanTypes[] = $q->installments;
			$loanTypes[] = $q->duration;
			$loanTypes[] = status($q->id,$q->status); 
			$loanTypes[] = actions($q->id); 
			
			$data[] = $loanTypes;
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data   
		);

		echo json_encode($json_data);		
	}

	function shareTypes(){
		$this->load->view('settings/shareTypes'); 
	}

	function share_types_list_()
	{
		function status($id='',$status=0)
		{
			if ($status == '1') {
				$stat = 'Active';
			} else {
				$stat = 'Inactive';
			}

			$str = '
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-green margin-right" href="#" id="view_share_type" idx="'.$id.'">'.$stat.'</a>
	            </div>
            ';
            
			return $str;
		} 

		function actions($id='')
		{
			$str = ' 
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-blue margin-right" href="#" id="edit_share_type" idx="'.$id.'">Edit</a>
	                <a type="button" class="btn-xs bg-red" href="#" id="delete_share_type" idx="'.$id.'">Delete</a>
	            </div>
            ';
            
			return $str;
		}

		$requestData = $_REQUEST;

		$query = $this->SettingsModel->get_share_types_($requestData,$totalData,$totalFiltered);

		$data = array();
		foreach ($query as $q) {
			$loanTypes = array(); 

			$loanTypes[] = $q->id;
			$loanTypes[] = $q->code;
			$loanTypes[] = $q->name;
			$loanTypes[] = $q->interest_rate;
			$loanTypes[] = $q->processing_rate;
			$loanTypes[] = $q->installments;
			$loanTypes[] = $q->duration;
			$loanTypes[] = status($q->status,$q->id); 
			$loanTypes[] = actions($q->id); 
			
			$data[] = $loanTypes;
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data   
		);

		echo json_encode($json_data);		
	}

	function chargeTypes(){
		$this->load->view('settings/chargeTypes');
	}

	function charge_types_list_()
	{
		function status($id='',$status=0)
		{
			if ($status == '1') {
				$stat = 'Active';
			} else {
				$stat = 'Inactive';
			}

			$str = '
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-green margin-right" href="#" id="view_charge_type" idx="'.$id.'">'.$stat.'</a>
	            </div>
            ';
            
			return $str;
		} 

		function actions($id='')
		{
			$str = ' 
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-blue margin-right" href="#" id="edit_charge_type" idx="'.$id.'">Edit</a>
	                <a type="button" class="btn-xs bg-red" href="#" id="delete_charge_type" idx="'.$id.'">Delete</a>
	            </div>
            ';
            
			return $str;
		}

		$requestData = $_REQUEST;

		$query = $this->SettingsModel->get_charge_types_($requestData,$totalData,$totalFiltered);

		$data = array();
		foreach ($query as $q) {
			$loanTypes = array(); 

			$loanTypes[] = $q->id;
			$loanTypes[] = $q->code;
			$loanTypes[] = $q->description;
			$loanTypes[] = $q->account;
			$loanTypes[] = $q->rate;
			$loanTypes[] = $q->rate_type;
			$loanTypes[] = $q->category;
			$loanTypes[] = status($q->id,$q->active);
			$loanTypes[] = actions($q->id);
			
			$data[] = $loanTypes;
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data   
		);

		echo json_encode($json_data);		
	}

	function depositTypes(){
		$this->load->view('settings/depositTypes');
	}

	function deposit_types_list_()
	{
		function status($id='',$status=0)
		{
			if ($status == '1') {
				$stat = 'Active';
			} else {
				$stat = 'Inactive';
			}

			$str = '
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-green margin-right" href="#" id="view_deposit_type" idx="'.$id.'">'.$stat.'</a>
	            </div>
            ';
            
			return $str;
		} 

		function actions($id='')
		{
			$str = ' 
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-blue margin-right" href="#" id="edit_deposit_type" idx="'.$id.'">Edit</a>
	                <a type="button" class="btn-xs bg-red" href="#" id="delete_deposit_type" idx="'.$id.'">Delete</a>
	            </div>
            ';
            
			return $str;
		}

		$requestData = $_REQUEST;

		$query = $this->SettingsModel->get_deposit_types_($requestData,$totalData,$totalFiltered);

		$data = array();
		foreach ($query as $q) {
			$loanTypes = array(); 

			$loanTypes[] = $q->id;
			$loanTypes[] = $q->code;
			$loanTypes[] = $q->description;
			$loanTypes[] = $q->sca;
			$loanTypes[] = $q->dca;
			$loanTypes[] = $q->w_type;
			$loanTypes[] = $q->w_rate;
			$loanTypes[] = status($q->id,$q->active);
			$loanTypes[] = actions($q->id);
			
			$data[] = $loanTypes;
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data   
		);

		echo json_encode($json_data);		
	}

	function securityTypes(){
		$this->load->view('settings/securityTypes');
	}

	function security_types_list_()
	{
		function status($id='',$status=0)
		{
			if ($status == '1') {
				$stat = 'Active';
			} else {
				$stat = 'Inactive';
			}

			$str = '
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-green margin-right" href="#" id="view_security_type" idx="'.$id.'">'.$stat.'</a>
	            </div>
            ';
            
			return $str;
		} 

		function actions($id='')
		{
			$str = ' 
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-blue margin-right" href="#" id="edit_security_type" idx="'.$id.'">Edit</a>
	                <a type="button" class="btn-xs bg-red" href="#" id="delete_security_type" idx="'.$id.'">Delete</a>
	            </div>
            ';
            
			return $str;
		}

		$requestData = $_REQUEST;

		$query = $this->SettingsModel->get_security_types_($requestData,$totalData,$totalFiltered);

		$data = array();
		foreach ($query as $q) {
			$loanTypes = array(); 

			$loanTypes[] = $q->id;
			$loanTypes[] = $q->code;
			$loanTypes[] = $q->details;
			$loanTypes[] = status($q->id,$q->active);
			$loanTypes[] = actions($q->id);
			
			$data[] = $loanTypes;
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data   
		);

		echo json_encode($json_data);		
	}

	function users(){
		$this->load->view('settings/users'); 
	}

	function users_list_()
	{

		function status($id='',$status=0)
		{
			if ($status == '1') {
				$stat = 'Active';
			} else {
				$stat = 'Inactive';
			}

			$str = '
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-green margin-right" href="#" id="view_user" idx="'.$id.'">'.$stat.'</a>
	            </div>
            ';
            
			return $str;
		} 

		function actions($id='')
		{
			$str = ' 
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-blue margin-right" href="#" id="edit_user" idx="'.$id.'">Edit</a>
	                <a type="button" class="btn-xs bg-red" href="#" id="delete_user" idx="'.$id.'">Delete</a>
	            </div>
            ';
            
			return $str;
		}

		$requestData = $_REQUEST;

		$query = $this->SettingsModel->get_users_list_($requestData,$totalData,$totalFiltered);

		$data = array();
		foreach ($query as $q) {
			$users = array(); 

			$users[] = $q->id;
			$users[] = $q->fullname;
			$users[] = $q->username;
			$users[] = $q->telephone;
			$users[] = $q->email;
			$users[] = $q->branch;
			$users[] = $q->role;
			$users[] = status($q->id,$q->status);
			$users[] = actions($q->id);
			
			$data[] = $users;
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data   
		);

		echo json_encode($json_data);		
	}

	function user(){
		$data['branches'] = $this->Index_Model->get_branches_();
		$data['roles'] = $this->Index_Model->get_user_roles_();
		$this->load->view('settings/user',$data); 
	}

	function add_user()
	{
		$user = $this->input->post();
		echo $this->Index_Model->add_user($user);
	}

	function view_user()
	{
		$data['roles'] = $this->Index_Model->get_user_roles_();
		$data['branches'] = $this->Index_Model->get_branches__();
		$data['user'] = $this->Index_Model->get_user($this->input->post('id'));
		$this->load->view('settings/view_user',$data); 
	}

	function edit_user()
	{
		$data['roles'] = $this->Index_Model->get_user_roles_();
		$data['branches'] = $this->Index_Model->get_branches__();
		$data['user'] = $this->Index_Model->get_user($this->input->post('id'));
		$this->load->view('settings/edit_user',$data); 
	}

	function update_user()
	{
		$user = $this->input->post();
		echo $this->Index_Model->update_user($user);
	}

	function delete_user()
	{
		echo $this->Index_Model->delete_user($this->input->post('id'));
	}

	function accounts(){
		$this->load->view('settings/accounts');
	}

	function accounts_list_()
	{
		function status($id='',$status=0)
		{
			if ($status == '1') {
				$stat = 'Active';
			} else {
				$stat = 'Inactive';
			}

			$str = '
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-green margin-right" href="#" id="view_account" idx="'.$id.'">'.$stat.'</a>
	            </div>
            ';
            
			return $str;
		} 

		function actions($id='')
		{
			$str = ' 
				<div class="btn-group-horizontal">
	                <a type="button" class="btn-xs bg-blue margin-right" href="#" id="edit_account" idx="'.$id.'">Edit</a>
	                <a type="button" class="btn-xs bg-red" href="#" id="delete_account" idx="'.$id.'">Delete</a>
	            </div>
            ';
            
			return $str;
		}

		$requestData = $_REQUEST;

		$query = $this->SettingsModel->get_accounts_list_($requestData,$totalData,$totalFiltered);

		$data = array();
		foreach ($query as $q) {
			$accounts = array(); 

			$accounts[] = $q->aid;
			$accounts[] = $q->code;
			$accounts[] = $q->description;
			$accounts[] = $q->category;
			$accounts[] = $q->control_ac;
			$accounts[] = status($q->aid,$q->active);
			$accounts[] = actions($q->aid);

			$data[] = $accounts;
		}

		$json_data = array(
			"draw"            => intval( $requestData['draw'] ),   
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data   
		);

		echo json_encode($json_data);		
	}

	function branch(){
		#$data['branches'] = $this->Index_Model->get_branches_();
		#$data['roles'] = $this->Index_Model->get_user_roles_();
		$this->load->view('settings/branch'); 
	}

	function add_branch()
	{
		$branch = $this->input->post();
		echo $this->Index_Model->add_branch($branch);
	}

	function view_branch()
	{
		$data['branch'] = $this->Index_Model->get_branch($this->input->post('id'));
		$this->load->view('settings/view_branch',$data); 
	}

	function edit_branch()
	{
		$data['branch'] = $this->Index_Model->get_branch($this->input->post('id'));
		$this->load->view('settings/edit_branch',$data); 
	}

	function update_branch()
	{
		$branch = $this->input->post();
		echo $this->Index_Model->update_branch($branch);
	}

	function delete_branch()
	{
		echo $this->Index_Model->delete_branch($this->input->post('id'));
	}

	function loan_type()
	{
		$this->load->view('settings/loanType'); 
	}

	function add_loan_type()
	{
		$loan_type = $this->input->post();
		echo $this->Index_Model->add_loan_type($loan_type);
	}

	function view_loan_type()
	{
		$data['loantype'] = $this->Index_Model->get_loan_type($this->input->post('id'));
		$this->load->view('settings/view_share_type',$data); 
	}

	function edit_loan_type()
	{
		$data['loantype'] = $this->Index_Model->get_loan_type($this->input->post('id'));
		$this->load->view('settings/edit_loan_type',$data); 
	}

	function update_loan_type()
	{
		$loan_type = $this->input->post();
		echo $this->Index_Model->update_loan_type($loan_type);
	}

	function delete_loan_type()
	{
		echo $this->Index_Model->delete_loan_type($this->input->post('id'));
	}

	function account()
	{
		$this->load->view('settings/account'); 
	}

	function add_account()
	{
		$account = $this->input->post();
		echo $this->Index_Model->add_account($account);
	}

	function view_account()
	{ 
		$data['account'] = $this->Index_Model->get_account($this->input->post('id'));
		$this->load->view('settings/view_account',$data); 
	}

	function edit_account()
	{
		$data['account'] = $this->Index_Model->get_account($this->input->post('id'));
		$this->load->view('settings/edit_account',$data); 
	}

	function update_account()
	{
		$account = $this->input->post();
		echo $this->Index_Model->update_account($account);
	}

	function delete_account()
	{
		echo $this->Index_Model->delete_account($this->input->post('id'));
	}

	function deposit_type()
	{
		$data['accounts'] = $this->Index_Model->get_accounts_();
		$this->load->view('settings/depositType',$data); 
	}

	function add_deposit_type()
	{
		$deposit_type = $this->input->post();
		echo $this->Index_Model->add_deposit_type($deposit_type);
	}

	function view_deposit_type()
	{
		$data['deposit'] = $this->Index_Model->get_deposit_type($this->input->post('id'));
		$data['accounts'] = $this->Index_Model->get_accounts_();
		$this->load->view('settings/view_deposit_type',$data); 
	}

	function edit_deposit_type()
	{
		$data['deposit'] = $this->Index_Model->get_deposit_type($this->input->post('id'));
		$data['accounts'] = $this->Index_Model->get_accounts_();
		$this->load->view('settings/edit_deposit_type',$data); 
	}

	function update_deposit_type()
	{
		$deposit_type = $this->input->post();
		echo $this->Index_Model->update_deposit_type($deposit_type);
	}

	function delete_deposit_type()
	{
		echo $this->Index_Model->delete_deposit_type($this->input->post('id'));
	}

	function share_type()
	{
		$this->load->view('settings/shareType'); 
	}

	function add_share_type()
	{
		$share_type = $this->input->post();
		echo $this->Index_Model->add_share_type($share_type);
	}

	function view_share_type()
	{
		$data['loantype'] = $this->Index_Model->get_share_type($this->input->post('id'));
		$this->load->view('settings/view_share_type',$data); 
	}

	function edit_share_type()
	{
		$data['loantype'] = $this->Index_Model->get_share_type($this->input->post('id'));
		$this->load->view('settings/edit_share_type',$data); 
	}

	function update_share_type()
	{
		$share_type = $this->input->post();
		echo $this->Index_Model->update_share_type($share_type);
	}

	function delete_share_type()
	{
		echo $this->Index_Model->delete_share_type($this->input->post('id'));
	}

	function charge_type()
	{
		$data['accounts'] = $this->Index_Model->get_accounts_();
		$this->load->view('settings/chargeType',$data); 
	}

	function add_charge_type()
	{
		$charge_type = $this->input->post();
		echo $this->Index_Model->add_charge_type($charge_type);
	}

	function view_charge_type()
	{
		$data['accounts'] = $this->Index_Model->get_accounts_();
		$data['charge'] = $this->Index_Model->get_charge_type($this->input->post('id'));
		$this->load->view('settings/view_charge_type',$data); 
	}

	function edit_charge_type()
	{
		$data['accounts'] = $this->Index_Model->get_accounts_();
		$data['charge'] = $this->Index_Model->get_charge_type($this->input->post('id'));
		$this->load->view('settings/edit_charge_type',$data); 
	}

	function update_charge_type()
	{
		$charge_type = $this->input->post();
		echo $this->Index_Model->update_charge_type($charge_type);
	}

	function delete_charge_type()
	{
		echo $this->Index_Model->delete_charge_type($this->input->post('id'));
	}

	function delete_security_type()
	{
		echo $this->Index_Model->delete_security_type($this->input->post('id'));
	}

	function security_type()
	{
		$this->load->view('settings/securityType'); 
	}

	function add_security_type()
	{
		$security_type = $this->input->post();
		echo $this->Index_Model->add_security_type($security_type);
	}

	function view_security_type()
	{
		$data['security'] = $this->Index_Model->get_security_type($this->input->post('id'));
		$this->load->view('settings/view_security_type',$data); 
	}

	function edit_security_type()
	{
		$data['security'] = $this->Index_Model->get_security_type($this->input->post('id'));
		$this->load->view('settings/edit_security_type',$data); 
	}

	function update_security_type()
	{
		$security_type = $this->input->post();
		echo $this->Index_Model->update_security_type($security_type);
	}

	
}
