                <!-- Content Header (Page header) -->
                <section class="content-header"><h1>Balance Sheet</h1>
                </section>

                <!-- Main content -->
                <section class="content">
        <div class="box box-success">
            <div class="box-header with-border">
              <h3 class="box-title">Select the Date of the Balance Sheet</h3>
            </div>
            <form class="form-horizontal" method="get" enctype="multipart/form-data">
                <input type="hidden" name="search" value="1">
                <div class="box-body">
                  <div class="row">
                      <script>
                        $(function() {
                            $('#startPicker,#endPicker').datepick({ 
                                onSelect: customRange, showTrigger: '#calImg', 
                                dateFormat: 'yyyy-mm-dd'}); 
                 
                                function customRange(dates) { 
                                    if (this.id == 'startPicker') { 
                                        $('#endPicker').datepick('option', 'minDate', dates[0] || null); 
                                    } 
                                    else { 
                                        $('#startPicker').datepick('option', 'maxDate', dates[0] || null); 
                                    } 
                                }
                        });
        
                    </script>
                    <div class="col-xs-5">
                        <input type="text" name="end_date" class="form-control is-datepick" id="endPicker" placeholder="To Date" value="06/10/2017" required="">
                    </div>
                    <div class="col-xs-2">
                        <span class="input-group-btn">
                          <button type="submit" class="btn bg-olive btn-flat">Search!</button>
                        </span>
                        <span class="input-group-btn">
                          <button type="button" class="btn bg-purple  btn-flat pull-right" onclick="parent.location='/accounting/balance_sheet.php'">Reset!</button>
                        </span>
                    </div>
                  </div>
                </div><!-- /.box-body -->
            </form>
          </div><!-- /.box -->
    <div class="row row-grid">
        <div id="pre_loader" style="display: none;">
            <div class="loader"></div>
            <div style="text-align:center; font-weight:bold;font-style:italic;">Loading Balance Sheet. Please wait...</div>
        </div>
    </div>                                                                                                                                                                                                                                                                
<script>
     function update_balance_sheet() 
     {
        var current_assets = 0;
        var investments = 0;
        var fixed_assets = 0;
        var intangible_assets = 0;
        var other_assets = 0;

        for (var i = 1; i <= 0; i++) {
            var fieldid = 'inputCurrentAssets'+i;
            if(document.getElementById(fieldid))
            {
                if (document.getElementById(fieldid).value != "")
                    current_assets = parseFloat(current_assets) + parseFloat(document.getElementById(fieldid).value)*100;
            }

            var fieldid = 'inputInvestments'+i;
            if(document.getElementById(fieldid))
            {
                if (document.getElementById(fieldid).value != "")
                    investments = parseFloat(investments) + parseFloat(document.getElementById(fieldid).value)*100;
            }

            var fieldid = 'inputFixedAssets'+i;
            if(document.getElementById(fieldid))
            {
                if (document.getElementById(fieldid).value != "")
                    fixed_assets = parseFloat(fixed_assets) + parseFloat(document.getElementById(fieldid).value)*100;
            }

            var fieldid = 'inputIntangibleAssets'+i;
            if(document.getElementById(fieldid))
            {
                if (document.getElementById(fieldid).value != "")
                    intangible_assets = parseFloat(intangible_assets) + parseFloat(document.getElementById(fieldid).value)*100;
            }
                
            var fieldid = 'inputOtherAssets'+i;
            if(document.getElementById(fieldid))
            {
                if (document.getElementById(fieldid).value != "")
                    other_assets = parseFloat(other_assets) + parseFloat(document.getElementById(fieldid).value)*100;
            }       
        }
        
        var inputCurrentLoansOutstanding = document.getElementById("inputCurrentLoansOutstanding").value;
        var inputCurrentLoansPastDue = document.getElementById("inputCurrentLoansPastDue").value;
        var inputCurrentLoansRestructured = document.getElementById("inputCurrentLoansRestructured").value;
        var inputLoanLossReserve = document.getElementById("inputLoanLossReserve").value;
        
        if (inputCurrentLoansOutstanding == "")
            inputCurrentLoansOutstanding = 0;
        if (inputCurrentLoansPastDue == "")
            inputCurrentLoansPastDue = 0;
        if (inputCurrentLoansRestructured == "")
            inputCurrentLoansRestructured = 0;
        if (inputLoanLossReserve == "")
            inputLoanLossReserve = 0;
        
        var loans_outstanding = parseFloat(inputCurrentLoansOutstanding)*100 + parseFloat(inputCurrentLoansPastDue)*100 + parseFloat(inputCurrentLoansRestructured)*100;
        var net_loans_outstanding = parseFloat(loans_outstanding) - parseFloat(inputLoanLossReserve)*100;
        var total_current_assets = parseFloat(net_loans_outstanding) + parseFloat(current_assets);
        var total_assets = parseFloat(total_current_assets) + parseFloat(investments) + parseFloat(fixed_assets) + parseFloat(intangible_assets) + parseFloat(other_assets);
        
        var inputClientSavings = document.getElementById("inputClientSavings").value;
        var inputAccountsPayable = document.getElementById("inputAccountsPayable").value;
        var inputWagesPayable = document.getElementById("inputWagesPayable").value;
        var inputShortTermBorrowings = document.getElementById("inputShortTermBorrowings").value;
        var inputLongTermDebtCommercial = document.getElementById("inputLongTermDebtCommercial").value;
        var inputLongTermDebtConcessional = document.getElementById("inputLongTermDebtConcessional").value;
        var inputOtherAccruedExpensesPayable = document.getElementById("inputOtherAccruedExpensesPayable").value;
        var inputIncomeTaxesPayable = document.getElementById("inputIncomeTaxesPayable").value;
        var inputRestrictedRevenue = document.getElementById("inputRestrictedRevenue").value;
        
        if (inputClientSavings == "")
            inputClientSavings = 0;
        if (inputAccountsPayable == "")
            inputAccountsPayable = 0;
        if (inputWagesPayable == "")
            inputWagesPayable = 0;
        if (inputShortTermBorrowings == "")
            inputShortTermBorrowings = 0;
        if (inputLongTermDebtCommercial == "")
            inputLongTermDebtCommercial = 0;
        if (inputLongTermDebtConcessional == "")
            inputLongTermDebtConcessional = 0;
        if (inputOtherAccruedExpensesPayable == "")
            inputOtherAccruedExpensesPayable = 0;
        if (inputIncomeTaxesPayable == "")
            inputIncomeTaxesPayable = 0;
        if (inputRestrictedRevenue == "")
            inputRestrictedRevenue = 0;
        
        var total_liabilities = parseFloat(inputClientSavings)*100 + parseFloat(inputAccountsPayable)*100 + parseFloat(inputWagesPayable)*100 + parseFloat(inputShortTermBorrowings)*100 + parseFloat(inputLongTermDebtCommercial)*100 + parseFloat(inputLongTermDebtConcessional)*100 + parseFloat(inputOtherAccruedExpensesPayable)*100 + parseFloat(inputIncomeTaxesPayable)*100 + parseFloat(inputRestrictedRevenue)*100;

        var inputRetainedNetSurplus = document.getElementById("inputRetainedNetSurplus").value;
        var inputNetSurplus = document.getElementById("inputNetSurplus").value;
        
        if (inputRetainedNetSurplus == "")
            inputRetainedNetSurplus = 0;
        if (inputNetSurplus == "")
            inputNetSurplus = 0;
        
        var equities = parseFloat(inputRetainedNetSurplus)*100 + parseFloat(inputNetSurplus)*100;
        
        var loan_fund = parseFloat(total_assets) - parseFloat(equities) - parseFloat(total_liabilities);
        var total_equities = parseFloat(loan_fund) + parseFloat(equities);
        var total_liabilities_equities = parseFloat(total_liabilities) + parseFloat(total_equities);
        
        if (current_assets != 0)
            document.getElementById("CurrentAssets").innerHTML = numberWithCommas((current_assets / 100).toFixed(2));
        if (net_loans_outstanding != 0)
            document.getElementById("NetLoansOutstanding").innerHTML = numberWithCommas((net_loans_outstanding / 100).toFixed(2));
        if (total_liabilities != 0)
            document.getElementById("TotalLiabilities").innerHTML = numberWithCommas((total_liabilities / 100).toFixed(2));
        if (total_current_assets != 0)
            document.getElementById("TotalCurrentAssets").innerHTML = numberWithCommas((total_current_assets / 100).toFixed(2));
        if (investments != 0)
            document.getElementById("TotalInvestments").innerHTML = numberWithCommas((investments / 100).toFixed(2));
        if (fixed_assets != 0)
            document.getElementById("TotalFixedAssets").innerHTML = numberWithCommas((fixed_assets / 100).toFixed(2));
        if (intangible_assets != 0)
            document.getElementById("TotalIntangibleAssets").innerHTML = numberWithCommas((intangible_assets / 100).toFixed(2));
        if (other_assets != 0)
            document.getElementById("TotalOtherAssets").innerHTML = numberWithCommas((other_assets / 100).toFixed(2));
        if (total_assets != 0)
            document.getElementById("TotalAssets").innerHTML = numberWithCommas((total_assets / 100).toFixed(2));
        if (loan_fund != 0)
            document.getElementById("LoanFundCapital").innerHTML = numberWithCommas((loan_fund / 100).toFixed(2));
        if (total_equities != 0)
            document.getElementById("TotalEquity").innerHTML = numberWithCommas((total_equities / 100).toFixed(2));
        if (total_liabilities_equities != 0)
            document.getElementById("TotalLiabilitiesEquity").innerHTML = numberWithCommas((total_liabilities_equities / 100).toFixed(2));
    }
    function numberWithCommas(x) {
        return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }
 </script>
<div class="box box-info">
    <div class="row">
        <div class="col-sm-12 text-center">
            <h3>BRANCH BALANCE SHEET<br>
            As at 6th October, 2017</h3>
        </div>
    </div>
    <div class="box-body">
            
        <form class="form-horizontal" method="post" enctype="multipart/form-data" name="form" id="form" target="_blank">
            <input type="hidden" name="generate_excel" value="1">
            
            <input type="hidden" name="to_date_heading" value="6th October, 2017">
            
            <div class="row">
                <div class="col-sm-6">
                    <table class="table table-bordered table-condensed table-hover">
                        <tbody><tr style="background-color: #F2F8FF">
                           <td colspan="3" class="text-center"><b>ASSETS</b></td>
                       </tr>
                       <tr>
                           <td class="text-bold text-blue"><b>Current Assets:</b></td>
                           <td></td>
                           <td></td>
                       </tr>
                       <tr>
                           <td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Loans Outstanding </b></td>
                           <td style="text-align:right"></td>
                           <td></td>
                       </tr>
                       <tr>
                           <td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Current</b></td>
                           <td style="text-align:right"><input type="text" name="current_loans_outstanding" id="inputCurrentLoansOutstanding" placeholder="" value="0" class="balance_sheet_input decimal-2-places" onkeyup="update_balance_sheet()"></td>
                           <td></td>
                       </tr>
                       
                       <tr>
                           <td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Past Due</b></td>
                           <td style="text-align:right"><input type="text" name="current_loans_past_due" id="inputCurrentLoansPastDue" placeholder="" value="0" class="balance_sheet_input decimal-2-places" onkeyup="update_balance_sheet()"></td>
                           <td></td>
                       </tr>
                       <tr>
                           <td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Restructured</b></td>
                           <td style="text-align:right; border-bottom: 1px solid #000"><input type="text" name="current_loans_restructured" id="inputCurrentLoansRestructured" placeholder="" value="0" class="balance_sheet_input decimal-2-places" onkeyup="update_balance_sheet()"></td>
                           <td></td>
                       </tr>
                       <tr>
                           <td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Loans Outstanding (Gross)</b></td>
                           <td style="text-align:right;" class="text-bold">0</td>
                           <td></td>
                       </tr>
                       <tr>
                           <td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(Loan Loss Reserve)</b></td>
                           <td style="text-align:right;  border-bottom: 1px solid #000"><input type="text" name="current_loan_loss_reserve" id="inputLoanLossReserve" placeholder="" value="" class="balance_sheet_input decimal-2-places" onkeyup="update_balance_sheet()"></td>
                           <td></td>
                       </tr>
                       <tr>
                           <td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Net Loans Outstanding</b></td>
                           <td></td>
                           <td style="text-align:right" class="text-bold"><div id="NetLoansOutstanding">0</div></td>
                       </tr>
                       <tr class="active">
                           <td style=""><b>Total Current Assets</b></td>
                           <td style=""></td>
                           <td style="text-align:right;" class="text-bold"><div id="TotalCurrentAssets">0</div></td>
                       </tr>
                       <tr>
                           <td class="text-blue"><b>Investments:</b></td>
                           <td></td>
                           <td></td>
                       </tr>
                       <tr class="active">
                           <td style=""><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Total Investments</b></td>
                           <td style=""> </td>
                           <td style="text-align:right;" class="text-bold"><div id="TotalInvestments">0</div></td>
                       </tr>
                       <tr>
                           <td class="text-blue"><b>Fixed Assets:</b></td>
                           <td></td>
                           <td></td>
                       </tr>
                       <tr class="active">
                           <td style=""><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Total Fixed Assets</b></td>
                           <td style=""> </td>
                           <td style="text-align:right;" class="text-bold"><div id="TotalFixedAssets">0</div></td>
                       </tr>
                       <tr>
                           <td class="text-blue"><b>Intangible Assets:</b></td>
                           <td></td>
                           <td></td>
                       </tr>
                       <tr class="active">
                           <td style=""><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Total Intangible Assets</b></td>
                           <td style=""> </td>
                           <td style="text-align:right;" class="text-bold"><div id="TotalIntangibleAssets">0</div></td>
                       </tr>
                       
                       <tr>
                           <td class="text-blue"><b>Other Assets:</b></td>
                           <td></td>
                           <td></td>
                       </tr>
                   
                       <tr class="active">
                           <td style=""><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Total Other Assets</b></td>
                           <td style=""> </td>
                           <td style="text-align:right;" class="text-bold"><div id="TotalOtherAssets">0</div></td>
                       </tr>
                    </tbody></table>
                </div>
                
                <div class="col-sm-6">
                    <table class="table table-bordered table-condensed table-hover">
                       <tbody><tr style="background-color: #F2F8FF">
                           <td colspan="3" class="text-center"><b>LIABILITY AND EQUITY</b></td>
                       </tr>
                       
                       <tr>
                           <td class="text-blue" colspan="2"><b>LIABILITIES</b></td>
                       </tr>
                       <tr>
                           <td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Client Savings</b></td>
                           <td style="text-align:right"><input type="text" name="client_savings" id="inputClientSavings" placeholder="" value="" class="balance_sheet_input decimal-2-places" onkeyup="update_balance_sheet()"></td>
                       </tr>
                       <tr>
                           <td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Accounts Payable</b></td>
                           <td style="text-align:right"><input type="text" name="accounts_payable" id="inputAccountsPayable" placeholder="" value="" class="balance_sheet_input decimal-2-places" onkeyup="update_balance_sheet()"></td>
                       </tr>
                       <tr>
                           <td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Wages Payable</b></td>
                           <td style="text-align:right"><input type="text" name="wages_payable" id="inputWagesPayable" placeholder="" value="" class="balance_sheet_input decimal-2-places" onkeyup="update_balance_sheet()"></td>
                       </tr>
                       <tr>
                           <td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Short-term Borrowings</b></td>
                           <td style="text-align:right"><input type="text" name="short_term_borrowings" id="inputShortTermBorrowings" placeholder="" value="" class="balance_sheet_input decimal-2-places" onkeyup="update_balance_sheet()"></td>
                       </tr>
                       <tr>
                           <td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Long-term Debt (commercial rate)</b></td>
                           <td style="text-align:right"><input type="text" name="long_term_debt_commercial" id="inputLongTermDebtCommercial" placeholder="" value="" class="balance_sheet_input decimal-2-places" onkeyup="update_balance_sheet()"></td>
                       </tr>
                       <tr>
                           <td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Long-term Debt (concessional rate)</b></td>
                           <td style="text-align:right"><input type="text" name="long_term_debt_concessional" id="inputLongTermDebtConcessional" placeholder="" value="" class="balance_sheet_input decimal-2-places" onkeyup="update_balance_sheet()"></td>
                       </tr>
                       
                       <tr>
                           <td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Other Accrued Expenses Payable</b></td>
                           <td style="text-align:right"><input type="text" name="other_accrued_expenses_payable" id="inputOtherAccruedExpensesPayable" placeholder="" value="" class="balance_sheet_input decimal-2-places" onkeyup="update_balance_sheet()"></td>
                       </tr>
                       <tr>
                           <td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Income Taxes Payable</b></td>
                           <td style="text-align:right"><input type="text" name="income_taxes_payable" id="inputIncomeTaxesPayable" placeholder="" value="" class="balance_sheet_input decimal-2-places" onkeyup="update_balance_sheet()"></td>
                       </tr>
                       <tr>
                           <td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Restricted Revenue</b></td>
                           <td style="text-align:right"><input type="text" name="restricted_revenue" id="inputRestrictedRevenue" placeholder="" value="" class="balance_sheet_input decimal-2-places" onkeyup="update_balance_sheet()"></td>
                       </tr>
                       <tr class="info">
                           <td><b>TOTAL LIABILITIES</b></td>
                           <td style="text-align:right;" class="text-bold"><div id="TotalLiabilities">0</div></td>
                       </tr>
                       <tr>
                           <td class="text-blue" colspan="2"><br><b>EQUITY</b></td>
                       </tr>
                       <tr>
                           <td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Loan Fund Capital</b></td>
                           <td style="text-align:right;" class="text-bold"><div id="LoanFundCapital">0</div></td>
                       </tr>
                       <tr>
                           <td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Retained Net Surplus/(Deficit) prior years</b></td>
                           <td style="text-align:right"><input type="text" name="retained_net_surplus" id="inputRetainedNetSurplus" placeholder="" value="" class="balance_sheet_input decimal-2-places" onkeyup="update_balance_sheet()"></td>
                       </tr>
                       <tr>
                           <td><b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Net Surplus/(Deficit) current year</b></td>
                           <td style="text-align:right"><input type="text" name="net_surplus" id="inputNetSurplus" placeholder="" value="" class="balance_sheet_input decimal-2-places" onkeyup="update_balance_sheet()"></td>
                       </tr>
                        <tr class="info">
                           <td><b>TOTAL EQUITY</b></td>
                           <td style="text-align:right;" class="text-bold"><div id="TotalEquity">0</div></td>
                       </tr>
                    </tbody></table>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-6">
                    <table class="table table-bordered table-condensed table-hover">
                        <tbody><tr class="info">
                           <td><b>TOTAL ASSETS</b></td>
                           <td style="text-align:right;" class="text-bold"><div id="TotalAssets">0</div></td>
                       </tr>
                    </tbody></table>
                </div>
                <div class="col-sm-6">
                    <table class="table table-bordered table-condensed table-hover">
                        <tbody><tr class="info">
                           <td><b>TOTAL LIABILITIES AND EQUITY</b></td>
                           <td style="text-align:right;" class="text-bold"><div id="TotalLiabilitiesEquity">0</div></td>
                       </tr>
                    </tbody></table>
                </div>
            </div>
                
            <button type="submit" class="btn btn-info pull-right" data-loading-text="<i class='fa fa-spinner fa-spin '></i> Please Wait. This can take a few minutes.">Export to Excel</button>
        </form>
    </div>
</div>
    <script>
    $( "#pre_loader" ).hide();
    </script>
    
                    </section>
     