<?php
    if ($borrower == 'undefined') {$borrower = '';}
?>

<form  class="form-horizontal" enctype="multipart/form-data" id="frm_edit_loan">
    <div class="box-body">
 
         <div class="form-group"> 
            <h3 align="center">EDIT LOAN</h3>
         </div>
         <div class="form-group"> 
            <label for="borrower" class="col-sm-3 control-label">Borrower ID #</label>                      
            <div class="col-sm-3">
                <input 
                    type="hidden" 
                    name="loan_ref" 
                    class="form-control" 
                    id="loan_ref" 
                    placeholder="" 
                    value="<?php echo $loan->loan_ref; ?>"
                >
                <input 
                    type="text" 
                    name="borrower_id" 
                    class="form-control" 
                    id="borrower_id" 
                    placeholder="" 
                    value="<?php echo $borrower; ?>"
                >
            </div>
            <div class="col-sm-3">
                <label>Click [ENTER] to search using ID</label>
            </div>
        </div>

        <div class="form-group">
            <label for="borrower" class="col-sm-3 control-label">Borrower</label>                      
            <div class="col-sm-6">
                <select id="borrower" class="form-control" name="borrower" >
                    <option value=""></option>
                    <?php foreach ($clients as $c) {?>
                        <option value="<?php echo $c->code;?>"><?php echo $c->name;?></option>
                    <?php } ?>
                </select>
            </div>
        </div>

        <div class="form-group">
            <label for="borrower" class="col-sm-3 control-label">Loan Officer</label>                      
            <div class="col-sm-6">
                <select id="loan_officer" class="form-control" name="loan_officer" >
                    <option value=""></option>
                    <?php foreach ($loan_officers as $l) {?>
                        <option value="<?php echo $l->code;?>"><?php echo $l->name;?></option>
                    <?php } ?>
                </select>
            </div>
        </div>

        <div class="form-group">
            <label for="branch" class="col-sm-3 control-label">Branch</label>                      
            <div class="col-sm-6">
                <select id="branch" class="form-control" name="branch" >
                    <option value=""></option>
                    <?php foreach ($branches as $b) {?>
                        <option value="<?php echo $b->code;?>"><?php echo $b->name;?></option>
                    <?php } ?>
                </select>
            </div>
        </div>

        <div class="form-group">
            <label for="inputBorrowerGender" class="col-sm-3 control-label">Loan type</label>                      
            <div class="col-sm-6">
                <?php 
                    $css = 'class="form-control" id="loan_type"';
                    echo form_dropdown('loan_type',$loanTypes_,$loan->loan_type,$css);
                ?>
            </div>
        </div> 
        
        <div class="form-group">
            <label for="loan_amount" class="col-sm-3 control-label">Loan Amount</label>                      
            <div class="col-sm-3">
                <input 
                type="text" 
                name="loan_amount" 
                class="form-control" 
                id="loan_amount" 
                placeholder="Loan amount in Ksh." 
                value="<?php echo $loan->amount;?>"
                >
            </div>
        </div>

       <div class="form-group">
            <label for="loan_period" class="col-sm-3 control-label">Installments </label>                      
            <div class="col-sm-2">
                <input type="text" name="installment" class="form-control" id="installment" placeholder="" value="<?php echo $loan->installments;?>">
            </div>

            <label for="installment_amt" class="col-sm-2 control-label">Installment Amount</label>                      
            <div class="col-sm-2">
                <input type="text" name="installment_amt" class="form-control" id="installment_amt" disabled="disabled" value="<?php echo $loan->installments_amt;?>">
             </div>
        </div>

        <div class="form-group">
            <label for="loan_date" class="col-sm-3 control-label">Date</label>                      
            <div class="col-sm-6">
                <input type="date" name="loan_date" class="form-control" id="loan_date" value="<?php echo date('Y-m-d',strtotime($loan->date_applied));?>">
            </div>
        </div>

        <div class="form-group">
            <label for="loan_date" class="col-sm-3 control-label">Processing Fee </label>                      
            <div class="col-sm-2">
                <input type="text" name="processing_fee" class="form-control" id="processing_fee" value="<?php echo $loan->fees;?>" >
            </div>
        </div>

        <div class="panel panel-default"><div class="panel-body bg-gray text-bold">Remarks</div></div>
        <div class="form-group">
            <label for="loan_date" class="col-sm-3 control-label">Reason</label>                      
            <div class="col-sm-6">
                <input type="text" name="reason" class="form-control" id="reason" value="" >
            </div>
        </div>

        <div class="box-footer">
            <div class="col-sm-3"></div>
            <button id="subMitLoan" class="btn btn-success pull-left">EDIT LOAN</button>            
        </div>
    </div>        
</form>


<script>
    $(function() {


        if ( $('#borrower_id').val() != "") {
            var borrower = $('#borrower_id').val();
            var url = '<?php echo base_url();?>client/getDetails_ID';
            $(document.body).css({'cursor' : 'wait'});
            $.post(url,{client:borrower},function(o_data,status){
                if (o_data == '') {
                    $("#borrower").val('');
                    $("#loan_officer").val('');
                    $("#branch").val('');
                    $("#loan_amount").val('');
                    alert("NO CUSTOMER WITH THIS ID NO!");
                } else {
                    var data = o_data.substring(1, o_data.length-1);
                    var client = JSON.parse(data); 
                    $("#borrower").val(client.code);
                    $("#loan_officer").val(client.loan_officer);
                    $("#branch").val(client.branch);
                    $("#loan_amount").val(client.loan_amt);
                }
                $(document.body).css({'cursor' : 'default'});
            });        
        }

        $('#borrower_id').off('keypress');
        $('#borrower_id').on('keypress',function(e) {
            if (e.which == 13) {
                e.preventDefault();
                var borrower = $('#borrower_id').val();
                var url = '<?php echo base_url();?>client/getDetails_ID';
                $(document.body).css({'cursor' : 'wait'});
                $.post(url,{client:borrower},function(o_data,status){
                    if (o_data == '') {
                        $("#borrower").val('');
                        $("#loan_officer").val('');
                        $("#branch").val('');
                        alert("NO CUSTOMER WITH THIS ID NO!");
                    } else {
                        var data = o_data.substring(1, o_data.length-1);
                        var client = JSON.parse(data); 
                        $("#borrower").val(client.code);
                        $("#loan_officer").val(client.loan_officer);
                        $("#branch").val(client.branch);
                     }
                    $(document.body).css({'cursor' : 'default'});
                });
            }
        });

        $('#subMitLoan').on('click',function(e){
            e.preventDefault();
            if (validated()) {
                $(document.body).css({'cursor' : 'progress'});
                var loan = $("#frm_edit_loan").serialize();
                var url = '<?php echo base_url();?>update_loan';
                $.post(url,{loan:loan},function(o_data,status){
                    alert(o_data);
                    $(document.body).css({'cursor' : 'default'});
                    //clear_data();
                   // $('#modal_add_new_loan').modal('hide');
                });
            }
        });

        function clear_data()
        {
            document.forms["frm_edit_loan"]["borrower"].value = '';
            document.forms["frm_edit_loan"]["loan_officer"].value = '';
            document.forms["frm_edit_loan"]["branch"].value = '';
            document.forms["frm_edit_loan"]["loan_type"].value = '';
            document.forms["frm_edit_loan"]["loan_amount"].value = '';
            document.forms["frm_edit_loan"]["loan_date"].value = '';
            document.forms["frm_edit_loan"]["installment"].value = '0';
            document.forms["frm_edit_loan"]["processing_fee"].value = '';
        }

        function validated()
        {
            var x = document.forms["frm_edit_loan"]["borrower"].value;

            if (x == "") {
                alert("Borrower must be filled out");
                document.forms["frm_edit_loan"]["borrower"].focus();
                return false;
            }

            x = document.forms["frm_edit_loan"]["loan_officer"].value;
            if (x == "") {
                alert("Loan Officer must be filled out");
                document.forms["frm_edit_loan"]["loan_officer"].focus();
                return false;
            }

            x = document.forms["frm_edit_loan"]["branch"].value;
            if (x == "") {
                alert("Branch must be filled out");
                document.forms["frm_edit_loan"]["branch"].focus();
                return false;
            }

            x = document.forms["frm_edit_loan"]["loan_type"].value;
            if (x == "") {
                alert("Loan Type must be filled out");
                document.forms["frm_edit_loan"]["loan_type"].focus();
                return false;
            }

            x = document.forms["frm_edit_loan"]["loan_amount"].value;
            if (x == "") {
                alert("Loan Amount must be filled out");
                document.forms["frm_edit_loan"]["loan_amount"].focus();
                return false;
            }

            x = document.forms["frm_edit_loan"]["loan_date"].value;
            if (x == "") {
                alert("Date must be filled out");
                document.forms["frm_edit_loan"]["loan_date"].focus();
                return false;
            }

            x = document.forms["frm_edit_loan"]["installment"].value;
            if (x == "") {
                alert("Installments must be filled out");
                document.forms["frm_edit_loan"]["installment"].focus();
                return false;
            }
            if (parseInt(x) == 0) {
                alert("Installments must be filled out");
                document.forms["frm_edit_loan"]["installment"].focus();
                return false;
            }

            x = document.forms["frm_edit_loan"]["reason"].value;
            if (x.trim() == "") {
                alert("Reason must be filled out");
                document.forms["frm_edit_loan"]["reason"].focus();
                return false;
            }

            return true;
        }

        $('#borrower').off('change');
        $('#borrower').on('change',function(e){
            e.preventDefault();
            var borrower = $(this).val();
            var url = '<?php echo base_url();?>client/getDetails';
            $(document.body).css({'cursor' : 'wait'});
            $.post(url,{client:borrower},function(o_data,status){
                var data = o_data.substring(1, o_data.length-1);
                var client = JSON.parse(data); 
                $("#loan_officer").val(client.loan_officer);
                $("#branch").val(client.branch);
                $(document.body).css({'cursor' : 'default'});
            });
        });


        $('#loan_type').off('change');
        $('#loan_type').on('change',function(e){
            e.preventDefault();
            var loan_type = $(this).val();
            var url = '<?php echo base_url();?>client/getLoanType';
            $(document.body).css({'cursor' : 'wait'});
            $.post(url,{loan_type:loan_type},function(o_data,status){
                var loan = JSON.parse(o_data.substring(1, o_data.length-1)); 
                $("#loan_amount").val(loan.min_amount);
                $("#installment").val(loan.installments);
                calc_amount();
                $(document.body).css({'cursor' : 'default'});
            });
        });

        $('#loan_amount').off('change');
        $('#loan_amount').on('change',function(e){
            e.preventDefault();
            $(document.body).css({'cursor' : 'wait'});
            calc_amount();
            $(document.body).css({'cursor' : 'default'});
            
        });

        $('#installment').off('change');
        $('#installment').on('change',function(e){
            var amount = $('#loan_amount').val();
            var insta = $('#installment').val();
            var insta_amt = amount / insta;
            $("#installment_amt").val(insta_amt);
        });
    });

    function calc_amount()
    {
        var b = $('#borrower').val();
        var t = $('#loan_type').val();
        var a = $('#loan_amount').val();
        var url = '<?php echo base_url();?>new_loan_info';
        $.post(url,{amount:a,type:t,borrower:b},function(o_data,status){
            var loan = JSON.parse(o_data.substring(1, o_data.length-1)); 
            $("#loan_payment").val(loan.repayt);
            $("#processing_fee").val(loan.processing_fee);
/*            $("#disbursement").val(loan.disbursement);
            $("#deposit_required").val(loan.deposit_required);
            $("#deposit_paid").val(loan.deposit_paid);
*/        });
    }
</script>
