<?php
  function ordinal($number) {
      $ends = array('th','st','nd','rd','th','th','th','th','th','th');
      if ((($number % 100) >= 11) && (($number%100) <= 13))
          return $number. 'th';
      else
          return $number. $ends[$number % 10];
  }
?>

<section class="content-header"><h1>Add Journal</h1></section>
  
  <section class="content">               
      <form action="#" class="form-horizontal" method="post" enctype="multipart/form-data" name="frm_add_journal" id="frm_add_journal">
            <div class="box box-info">     
                <div class="box-body">
                    <div class="panel panel-default"><div class="panel-body bg-gray text-bold">Required Fields:</div></div>

                    <div class="form-group">
                        <label for="inputJournalTypeId" class="col-sm-3 control-label">Journal Reference/Batch</label>
                        <div class="col-sm-5">
                            <input type="text" name="journal_ref" class="form-control" id="journal_ref" placeholder="" value="" required="">
                        </div>
                    </div> 

                    <div class="form-group">
                        <label for="inputJournalTypeId" class="col-sm-3 control-label">Debit Account</label>
                        <div class="col-sm-5">
                            <select class="form-control" name="debit_account" id="debit_account">
                                <option value="">Select An Account</option>
                                <?php foreach ($accounts as $e) { ?>
                                  <option value="<?php echo $e->code;?>"><?php echo $e->description;?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div> 

                    <div class="form-group">
                        <label for="inputJournalTypeId" class="col-sm-3 control-label">Credit Account</label>
                        <div class="col-sm-5">
                            <select class="form-control" name="credit_account" id="credit_account">
                                <option value="">Select An Account</option>
                                <?php foreach ($accounts as $a) { ?>
                                  <option value="<?php echo $a->code;?>"><?php echo $a->description;?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                  
                    <div class="form-group">
                        <label for="branch" class="col-sm-3 control-label">Branch</label>                      
                        <div class="col-sm-5">
                            <select id="branch" class="form-control" name="branch" >
                                <option value=""></option>
                                <?php foreach ($branches as $b) {?>
                                    <option value="<?php echo $b->code;?>"><?php echo $b->name;?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>

                  <div class="form-group">
                      <label for="borrower" class="col-sm-3 control-label">Staff</label>                      
                      <div class="col-sm-5">
                          <select id="officer" class="form-control" name="officer" >
                              <option value=""></option>
                              <?php foreach ($officers as $l) {?> ,
                                  <option value="<?php echo $l->username;?>"><?php echo $l->fullname;?></option>
                              <?php } ?>
                          </select>
                      </div>
                  </div>

                    <div class="form-group">
                        
                        <label for="inputJournalAmount" class="col-sm-3 control-label">Journal Amount</label>                      
                        <div class="col-sm-3">
                        <input type="text" name="journal_amount" class="form-control decimal-2-places" id="journal_amount" placeholder="Number or decimal only" value="" required="">
                        </div>
                      
                    </div>

                    <div class="form-group">
                    
                        <label for="inputJournalDate" class="col-sm-3 control-label">Journal Date</label>                      
                        <div class="col-sm-3">
                            <input type="text" name="journal_date" class="form-control is-datepick" id="journal_date" placeholder="yyyy-mm-dd" value="" required="">
                        </div>
                  
                    </div>

                    <div class="form-group">
                        
                        <label for="inputJournalDescription" class="col-sm-3 control-label">Description</label>                      
                        <div class="col-sm-6">
                            <textarea name="journal_description" class="form-control" id="journal_description" rows="3"></textarea>
                        </div>
                      
                    </div> 

                    <div class="panel panel-default"><div class="panel-body bg-gray text-bold">Optional Fields:</div></div>
                    <div class="form-group">
                        <label for="inputRecurring" class="col-sm-3 control-label">Is  Journal Recurring?</label>   
                        <div class="col-sm-9">
                            <div class="radio">
                                <label>
                                  <input type="radio" name="journal_recurring" id="inputJournalRecurringNo" value="0" onclick="enableDisableRecurringPeriod()" checked=""> No
                                    
                                </label>
                                &nbsp;&nbsp;&nbsp;&nbsp;
                                <label>
                                  <input type="radio" name="journal_recurring" id="inputJournalRecurringYes" value="1" onclick="enableDisableRecurringPeriod()"> Yes
                                </label>
                            </div>
                            If you select Yes, then the Journal will be automatically added by system every month.
                        </div>
                    </div>
                    <div class="form-group">
                      
                        <label for="inputRecurringPeriod" class="col-sm-3 control-label">Add Recurring Journal Day</label>
                        <div class="col-sm-5">
                            <select class="form-control" name="journal_recurring_period" id="journal_recurring_period">
                                <option value="0" selected=""></option>
                                <?php for($i=1;$i<32;$i++) { ?>
                                    <option value="<?php echo $i;?>"><?php echo ordinal($i);?></option>
                                <?php } ?>
                                <option value="32">
                                    End  of every month
                                </option>
                            </select>
                        </div> 
                    </div> 
                    <hr>                   
                    
                </div>
              
                <div class="box-footer">
                       <label for="LabelSavingReceipt" class="col-sm-3 control-label"></label>                      
                      <button 
                          type="submit" 
                          class="btn btn-info pull-left col-sm-3" 
                          data-loading-text="<i class='fa fa-spinner fa-spin '></i> Please Wait"
                          id="btn_add_journal">Submit
                      </button>
                    
                </div>
            </div>
        </form>

</section>



<script>
    $(function() {

        $('#btn_add_journal').on('click',function(e){
            e.preventDefault();
            if (validated()) {
                if (confirm('Add Journal')) {
                    $(document.body).css({'cursor' : 'progress'});
                    var journal = $("#frm_add_journal").serialize();
                    var url = '<?php echo base_url();?>save_journal';
                    $.post(url,{journal:journal},function(o_data,status){
                        alert(o_data);
                        $(document.body).css({'cursor' : 'default'});
                        clear_data();
                    });
                } 
            }
        });

        function clear_data()
        {
            document.forms["frm_add_journal"]["journal_ref"].value = '';
            document.forms["frm_add_journal"]["debit_account"].value = '';
            document.forms["frm_add_journal"]["credit_account"].value = '';
            document.forms["frm_add_journal"]["branch"].value = '';
            document.forms["frm_add_journal"]["officer"].value = '';
            document.forms["frm_add_journal"]["journal_amount"].value = '';
            document.forms["frm_add_journal"]["journal_date"].value = '';
            document.forms["frm_add_journal"]["journal_description"].value = '';
            document.forms["frm_add_journal"]["journal_recurring"].value = '0';
            document.forms["frm_add_journal"]["journal_recurring_period"].value = '';
        }

        function validated()
        {
            var x = document.forms["frm_add_journal"]["journal_ref"].value;

            if (x == "") {
                alert("Journal Reference must be filled out");
                document.forms["frm_add_journal"]["journal_ref"].focus();
                return false;
            }

            x = document.forms["frm_add_journal"]["debit_account"].value;
            if (x == "") {
                alert("Debit account must be filled out");
                document.forms["frm_add_journal"]["debit_account"].focus();
                return false;
            }

            x = document.forms["frm_add_journal"]["credit_account"].value;
            if (x == "") {
                alert("Credit Account must be filled out");
                document.forms["frm_add_journal"]["credit_account"].focus();
                return false;
            }

            x = document.forms["frm_add_journal"]["journal_date"].value;
            if (x == "") {
                alert("Date must be filled out");
                document.forms["frm_add_journal"]["journal_date"].focus();
                return false;
            }

            x = document.forms["frm_add_journal"]["journal_description"].value;
            if (x == "") {
                alert("Description must be filled out");
                document.forms["frm_add_journal"]["journal_description"].focus();
                return false;
            }

            x = document.forms["frm_add_journal"]["branch"].value;
            if (x == "") {
                alert("Branch must be filled out");
                document.forms["frm_add_journal"]["branch"].focus();
                return false;
            }

            x = document.forms["frm_add_journal"]["officer"].value;
            if (x == "") {
                alert("Staff must be filled out");
                document.forms["frm_add_journal"]["officer"].focus();
                return false;
            }

            x = document.forms["frm_add_journal"]["journal_amount"].value;
            if (x == "") {
                alert("Amount must be filled out");
                document.forms["frm_add_journal"]["journal_amount"].focus();
                return false;
            }

            return true;
        }

    });

</script>