<section class="content-header"><h1>Loans in Arrears</h1></section>

<section class="content"><p>Open loans that have due repayments based on the Loan Schedule dates.</p>
    <?php $this->load->view('utils/loan_search'); ?>
        <div class="box box-info">
            <div class="box-body">
                <div class="col-sm-12 table-responsive">
                    <div id="view-loans_wrapper" class="dataTables_wrapper form-inline dt-bootstrap no-footer">

                        <table id="loans-grid"  
                            cellpadding="0" 
                            cellspacing="0" 
                            border="0" 
                            class="display w3-table w3-striped w3-bordered w3-border w3-hoverable w3-white" 
                            width="100%"
                          >
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Loan #</th>
                                    <th>Type</th>
                                    <th>Borrower</th>
                                    <th>Principal</th>
                                    <th>Loan Officer</th>
                                    <th>Arrears</th>
                                    <th>Days</th>
                                    <th>Branch</th>
                                    <th>Balance</th>
                               </tr>
                            </thead>
                            <tfoot>
                                <tr>
                                    <th>#</th>
                                    <th>Loan #</th>
                                    <th>Type</th>
                                    <th>Borrower</th>
                                    <th><div id="total_principal" style="color:red"></div></th>
                                    <th>Loan Officer</th>
                                    <th><div id="arrears_amt" style="color:red"></div></th>
                                    <th><div id="arrears_days" style="color:red"></div></th>
                                    <th>Branch</th>
                                    <th><div id="total_loans" style="color:red"></div></th>
                               </tr>
                            </tfoot>

                          <tbody>
                          </tbody>
                      </table>
                    </div>
                </div>
            </div>
        </div>

</section>
 
 <script type="text/javascript" language="javascript" >
    $(document).ready(function() {
      var dataTable = $('#loans-grid')
                .on('xhr.dt', function ( e, settings, json, xhr ) {
                    $('#total_loans').html(json.total_loans);
                    $('#arrears_amt').html(json.arrears_amt);
                    $('#arrears_days').html(json.arrears_days);
                    $('#total_principal').html(json.total_principal);
                })
                .DataTable({
                    "processing": true,
                    "serverSide": true,
                    "ajax":{
                      url :"<?php echo site_url();?>borrowers/arrears_loans_list_",
                      type: "post", 
                      data : function(data) {
                            data.loan_type  = $('#select_loan_type').val();
                            data.loan_officer  = $('#select_loan_officer').val();
                            data.branch  = $('#select_branch').val();
                            data.date_from  = $('#select_date_from').val();
                            data.date_to  = $('#select_date_to').val();
                            data.loan_status  = $('#select_status').val();
                      },
                      error: function(xhr,status,error){
                        alert(xhr.responseText);
                        $(".employee-grid-error").html("");
                        $("#borrowers-grid").append('<tbody class="employee-grid-error"><tr><th colspan="3">No data found in the server</th></tr></tbody>');
                        $("#employee-grid_processing").css("display","none");
                      }
                    }
                  });
    });

  </script>