<section class="content-header"><h1>MPESA Repayments List</h1></section>

<section class="content"><p></p> 
     <?php $this->load->view('utils/loan_search_1'); ?>
        <div class="box box-info">
            <div class="box-body">
                <div class="col-sm-12 table-responsive">
                    <div id="view-loans_wrapper" class="dataTables_wrapper form-inline dt-bootstrap no-footer">

                        <table id="loans-grid"  
                            cellpadding="0" 
                            cellspacing="0" 
                            border="0" 
                            class="display w3-table w3-striped w3-bordered w3-border w3-hoverable w3-white" 
                            width="100%"
                          >
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Transaction</th>  
                                    <th>Reference</th>                                      
                                    <th>Time</th>
                                    <th>Shortcode</th>
                                    <th>Payee</th>
                                    <th>Names</th>
                                    <th>Amount</th>
                                    <th>Balance</th>
                                    <th>Posted</th>
                                    <th>Receipt</th>
                                </tr>
                            </thead>
                            <tfoot>
                                <tr>
                                    <th>#</th>
                                    <th>Transaction</th>  
                                    <th>Reference</th>                                      
                                    <th>Time</th>
                                    <th>Shortcode</th>
                                    <th>Payee</th>
                                    <th>Names</th>
                                    <th><div id="total" style="color:red"></div></th>
                                    <th>Balance</th>
                                    <th>Posted</th>
                                    <th>Receipt</th>
                                </tr>
                            </tfoot>

                          <tbody>
                          </tbody>
                      </table>
                    </div>
                </div>
            </div>
        </div>

</section> 

 <script type="text/javascript" language="javascript" >
    $(document).ready(function() {
      
      var dataTable = $('#loans-grid')
        .on('xhr.dt', function ( e, settings, json, xhr ) {
                    $('#total').html(json.total);
                    $('#balance').html(json.balance);
        })
        .DataTable({
            "processing": true,
            "serverSide": true,
            "ajax":{
              url :"<?php echo site_url();?>repayments/mpesa_payments_list_",
              type: "post", 
              data : function(data) {
                    data.loan_type  = $('#select_loan_type').val();
                    data.loan_officer  = $('#select_loan_officer').val();
                    data.branch  = $('#select_branch').val();
                    data.date_from  = $('#select_date_from').val();
                    data.date_to  = $('#select_date_to').val();
                    data.loan_status  = $('#select_status').val();
              },
              error: function(xhr,status,error){
                alert(xhr.responseText);
                $(".employee-grid-error").html("");
                $("#loans-grid").append('<tbody class="employee-grid-error"><tr><th colspan="3">No data found in the server</th></tr></tbody>');
                $("#employee-grid_processing").css("display","none");
              }
            },
            initComplete: function() {
                $('#loans-grid_filter input').unbind();
                $('#loans-grid_filter input').bind('keyup', function(e) {
                    if(e.keyCode == 13) {
                        dataTable.search(this.value).draw();
                    }
                });
            }
      });

    });

  </script>