
                <!-- Content Header (Page header) -->
                <section class="content-header"><h1>Upload Repayments from CSV file</h1>
                </section>

                <!-- Main content -->
                <section class="content">               
<script type="text/javascript">
        $(document).ready(function() {
          if (window.FormData) {
              $('#data_files').bind({
                  change : function()
                  {
                      var input = document.getElementById('data_files');
                      files = input.files;
                      
                      if (files.length > 20) {
                          alert('You can only upload max of 20 files');
                          $('#data_files').val("");
                          return false;
                      }
                      else {
                          var regExp = new RegExp('(application/pdf|application/acrobat|applications/vnd.pdf|text/pdf|text/x-pdf|application/msword|application/x-msword|application/vnd.openxmlformats-officedocument.wordprocessingml.document|application/vnd.openxmlformats-officedocument.spreadsheetml.sheet|text/csv|text/plain|application/csv|application/x-csv|text/comma-separated-values|application/zip|application/excel|application/ms-excel|application/vnd.ms-excel|application/vnd.msexcel|text/anytext|application/octet-stream|application/txt|image/png|image/jpeg|image/gif|application/zip|application/x-zip|application/octet-stream|application/x-zip-compressed|text/x-fortran)', 'i');
                          for (var i = 0; i < files.length; i++)
                          {
                              var file = files[i];
                              var filesize = file.size;
                              if (file.type != '')
                              {
                                  var matcher = regExp.test(file.type);
                                  if (!matcher)
                                  {
                                      $.alert({
                                          title: "Error",
                                          content: "You can only upload text, word, pdf, image, zip, csv, or excel files.",
                                          type: "red"
                                        });
                                      $('#data_files').val("");
                                      return false;
                                  }
                              }
                              if (filesize > 30000000)
                              {
                                  $.alert({
                                          title: "Error",
                                          content: "File must not be more than 30mb.",
                                          type: "red"
                                        });
                                        
                                  $('#data_files').val("");
                                  return false;
                              }
                          }
                      } 
                  }
              });
              $('#photo_file').bind({
                  change : function()
                  {
                      var input = document.getElementById('photo_file');
                      files = input.files;
                      
                      if (files.length > 1) {
                          $.alert({
                              title: "Error",
                              content: "You can only upload max of 1 file.",
                              type: "red"
                            });
                          $('#photo_file').val("");
                          return false;
                      }
                      else {
                          var regExp = new RegExp('(image/png|image/jpeg|image/gif)', 'i');
                          for (var i = 0; i < files.length; i++)
                          {
                              var file = files[i];
                              var filesize = file.size;
                              if (file.type != '')
                              {
                                  var matcher = regExp.test(file.type);
                                  if (!matcher)
                                  {
                                      $.alert({
                                          title: "Error",
                                          content: "You can only upload png, jpeg, or gif files.",
                                          type: "red"
                                        });
                                      $('#photo_file').val("");
                                      return false;
                                  }
                              }
                              if (filesize > 30000000)
                              {
                                  $.alert({
                                          title: "Error",
                                          content: "File must not be more than 30mb.",
                                          type: "red"
                                        });
                                  $('#photo_file').val("");
                                  return false;
                              }
                          }
                      } 
                  }
              });
              $('#csv_file').bind({
                  change : function()
                  {
                      var input = document.getElementById('csv_file');
                      files = input.files;
                      
                      if (files.length > 1) {
                          $.alert({
                              title: "Error",
                              content: "You can only upload max of 1 file.",
                              type: "red"
                            });
                          $('#csv_file').val("");
                          return false;
                      }
                      else {
                          var regExp = new RegExp('(text/csv|text/plain|application/csv|application/x-csv|text/comma-separated-values|application/excel|application/ms-excel|application/vnd.ms-excel|application/vnd.msexcel|text/anytext|application/octet-stream|application/txt|text/x-fortran)', 'i');
                          for (var i = 0; i < files.length; i++)
                          {
                              var file = files[i];
                              var matcher = regExp.test(file.type);
                              if (file.type != '')
                              {
                                  var filesize = file.size;
                                  if (!matcher)
                                  {
                                      $.alert({
                                          title: "Error",
                                          content: "You can only upload csv file.",
                                          type: "red"
                                        });
                                      $('#csv_file').val("");
                                      return false;
                                  }
                              }
                              if (filesize > 30000000)
                              {
                                  $.alert({
                                          title: "Error",
                                          content: "File must not be more than 30mb.",
                                          type: "red"
                                        });
                                  $('#csv_file').val("");
                                  return false;
                              }
                          }
                      } 
                  }
              });
          }
        });
        </script>

        <div class="box box-info">
            <div class="box-header with-border">
                <h3 class="box-title"><b>Step 1: Upload File</b></h3>
            </div>
                <div class="box-body">
                    <p>If you have repayments data in an Excel or CSV file, you can import the data using this page.</p>
                    
    <h3>How to convert Excel file to CSV</h3>

        <ul>
            <li>Open your excel file.</li>
            <li>Click on <b>File</b> and <b>Save as</b>.</li>
            <li>Select where you would like to save the file (like your desktop or a drive).<br>
            <img src="<?php echo base_url();?>/images/save_as_csv.jpg">
            </li>
            <li>In the <b>File Name</b> area, name your document.</li>
            <li>In the <b>Save as Type</b> area, select <b>CSV(Comma Delimited)</b> from the pull down menu.<br>
            Besides CSV (comma delimited), there is CSV (Macintosh) and CSV (MS-DOS) formats available. Do not save the file as these formats.<br>
            <img src="<?php echo base_url();?>/images/save_as_csv2.jpg">
            </li>
            <li>Click <b>Save</b>.</li>
            <li>You may receive one or two warning about the formatting of .csv, click <b>yes</b>.</li>
        </ul>
                    
                    <hr>
                    <div class="well">
                        <h4 class="text-bold">Prepare your repayments file:</h4>
                        <div class="box-body">
                        <div class="row">
                            <div class="col-sm-3 text-right text-bold text-red"><u>Required Columns</u></div>
                            <div class="col-sm-7 text-bold"><u>Allowed Values</u></div>                           
                            <div class="col-sm-3 text-right text-bold">Amount</div>
                            <div class="col-sm-7">Numbers or Decimals only                      <br>      
                                </div>                           
                            <div class="col-sm-3 text-right text-bold">Collection Method</div>
                            <div class="col-sm-7">Cash<br>ATM<br>Cheque<br>Paypal<br>Online Transfer<br><small><a href="<?php echo base_url();?>/admin/view_loan_repayment_methods.php" target="_blank">Add/Edit Repayment Methods</a></small><br>                      <br>      
                                </div>                           
                            <div class="col-sm-3 text-right text-bold">Collection Date</div>
                            <div class="col-sm-7">yyyy-mm-dd<br>                      <br>      
                                </div>                           
                            <div class="col-sm-3 text-right text-bold">Loan Unique Number</div>
                            <div class="col-sm-7">Unique Loan Number. If you don't enter a loan unique number, a Loan column will be added in Step 2 so you can select the corresponding loan for each repayment. <br>                      <br>      
                                </div>                           
                            <div class="col-sm-3 text-right text-bold">Collected By</div>
                            <div class="col-sm-7">peter MUCHEMI<br><small><a href="<?php echo base_url();?>/admin/view_collectors.php" target="_blank">Add/Edit Collectors</a></small><br>                      <br>      
                                </div>
                            <div class="col-sm-3 text-right text-bold text-yellow"><u>Optional Columns</u></div>
                            <div class="col-sm-7 text-bold"><u>Allowed Values</u></div>                           
                            <div class="col-sm-3 text-right text-bold">Description</div>
                            <div class="col-sm-7">Any<br>                      <br>      
                                </div>
                        </div>
                    </div>
                    <h4 class="text-bold">Tips:</h4>
                    <ul>
                        <li><a href="<?php echo base_url();?>/sample_file_bulk_repayments.csv" target="_blank">Click here to download a sample file.</a></li>
                        <li>Repayments will be uploaded in <b>Branch #1</b> since you are  currently logged into this branch.</li>
                        <li>It is <b>advisable that you have a Loan Unique Number column</b> in the repayments file otherwise you will have to manually select the loan number for each repayment.</li>
                        <li>Please delete commas and currency symbols in the Amount column. <b>Only have numbers or decimals in the Amount column.</b></li>
                        <li>The Collection Date column must have dates in the <b>yyyy-mm-dd</b> format.</li>
                        <li>You can upload a maximum of 4500 entries in 1 file. If you have more entries, please split them into multiple files.</li>
                       
                    </ul>
                </div>
               <div class="panel panel-default"><div class="panel-body bg-gray text-bold">Select the options that apply to all repayments in the file:</div></div>
                <form class="form-horizontal" method="post" enctype="multipart/form-data" id="bulk_upload_form">
                    <input type="hidden" name="bulk_upload_step" value="2">     
       
                    <div class="form-group">
                        <label for="inputRecurring" class="col-sm-5 control-label">Do you have Loan # column in the repayments file?</label>   
                        <div class="col-sm-7">
                            <div class="radio">
                                <label>
                                  <input type="radio" name="show_loan_number_column" id="inputLoanNo" value="1" checked=""> No
                                    
                                </label>
                                &nbsp;&nbsp;&nbsp;&nbsp;
                                <label>
                                  <input type="radio" name="show_loan_number_column" id="inputLoanYes" value="0"> Yes
                                </label>
                            </div>
                            If you select <b>No</b> above, a <b>Loan #</b> column will be added in Step 2 so you can select the corresponding loan # for each repayment.
                        </div>
                    </div>    
                    
                    <div class="form-group">
                        <label class="col-sm-5 control-label">Do you have a Collection Method column in the repayments file?</label>   
                        <div class="col-sm-7">
                            <div class="radio">
                                <label>
                                  <input type="radio" name="show_method_column" id="inputMethodNo" value="1" checked=""> No
                                    
                                </label>
                                &nbsp;&nbsp;&nbsp;&nbsp;
                                <label>
                                  <input type="radio" name="show_method_column" id="inputMethodYes" value="0"> Yes
                                </label>
                            </div>
                            If you select <b>No</b> above, a <b>Collection Method</b> column will be added in Step 2 so you can select the collection method for each repayment.
                        </div>
                    </div>   
                    
                    <div class="form-group">
                        <label class="col-sm-5 control-label">Do you have a Collection By column in the repayments file?</label>   
                        <div class="col-sm-7">
                            <div class="radio">
                                <label>
                                  <input type="radio" name="show_collection_by_column" id="inputCollectionByNo" value="1" checked=""> No
                                    
                                </label>
                                &nbsp;&nbsp;&nbsp;&nbsp;
                                <label>
                                  <input type="radio" name="show_collection_by_column" id="inputCollectionByYes" value="0"> Yes
                                </label>
                            </div>
                            If you select <b>No</b> above, a <b>Collection By</b> column will be added in Step 2 so you can select the collector for each repayment.
                        </div>
                    </div>   
                    <div class="panel panel-default"><div class="panel-body bg-gray text-bold">Upload your file:</div></div>  
                    
                    <div class="form-group">
                        <label class="col-sm-5 control-label">Columns Separated By</label>   
                        <div class="col-sm-4">
                            <select class="form-control" name="bulk_upload_separator" id="inputSeparator" required="">
                                <option value="comma">Comma,</option>
                                <option value="semicolon">Semicolon;</option>
                            </select>
                        </div>
                    </div> 
                    <div class="form-group">
                        <label for="csv_file" class="col-sm-5 control-label">Upload CSV File(.csv)</label>
                        <div class="col-sm-7">    
                            <input type="file" id="csv_file" name="upload_csv_file" required="">
                        </div>  
                    </div>
                </form></div>
                <div class="box-footer">
                    <button type="button" class="btn btn-default" onclick="parent.location='<?php echo base_url();?>/repayments/add_bulk_repayments_csv.php'">Reset</button>
                    <button type="submit" class="btn btn-info pull-right" data-loading-text="<i class='fa fa-spinner fa-spin '></i> Please Wait.">Go to Step 2</button>
                    
    <script type="text/javascript">
    $('#bulk_upload_form').on('submit', function(e) {
        
        $(this).find('button[type=submit]').prop('disabled', true);
        $('.btn').prop('disabled', true);
        $('.btn').button('loading');
        return true;
    });
    </script>
                </div><!-- /.box-footer -->
            
        </div>
    <script>
    $( "#pre_loader" ).hide();
    </script>
    
                    </section>
   