<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Login extends CI_Controller {
 
    public function __construct() {
        parent::__construct();
    }
	
    public function index() {
        $data['branches'] = array();//$this->Login_Model->get_branches__(1);
        $this->load->view('login/index',$data);
    } 
  
    public function logmein() {
        $user = $this->input->post('userid');
        $passwd = $this->input->post('password');
        $branch = $this->input->post('branch');

        if (trim($user) == '') {
            redirect('/login/');
        }

        if (trim($passwd) == '') {
            redirect('/login/');
        }

        $this->auth_user($user, $passwd);
    }

    function auth_user($user, $passwd) {
        $user_known = $this->Login_Model->authenticate_user($user, $passwd);
        $branch = 'X';
        if (is_scalar($user_known)) {
            redirect('/login/logout');
        } else {
            $this->session->set_userdata('id', trim($user_known->id));
            $this->session->set_userdata('username', trim($user_known->name));
            $this->session->set_userdata('usercode', trim($user_known->code));
            $this->session->set_userdata('logged_in', '1');
            $this->session->set_userdata('company', "GOLDVIEN SOLUTIONS LTD");

            $this->Index_Model->audit_trail('SYSTEM','Log In','Logged In');
            redirect('/dashboard');
        }
    }

    function logout() {
        $user = $this->session->userdata('username');
        $this->Index_Model->audit_trail('SYSTEM','Log Out','Logged Out');

        $this->session->sess_destroy();

        redirect('/login/');
    }

    function password() {
        $data['title'] = 'Change Password';
        $data['subtitle'] = $data['title'];
        $data['subdesc'] = 'Change Password';
        $this->load->view('login/password');
    }

    function password_user() {
        $data['title'] = 'Change Password';
        $data['subtitle'] = $data['title'];
        $data['subdesc'] = 'Change Password';
         $this->load->view('login/password_user');
    }

    function password_check() {
        $password = $this->input->post('password');
        $rpassword = $this->input->post('rpassword');

        if ($password != $rpassword) {
            $this->form_validation->set_message('password_check', 'The Password and Repeat Password are not the same!');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    function change_password() {
        $this->form_validation->set_rules('password', 'New Password', 'required');
        $this->form_validation->set_rules('rpassword', 'Password', 'callback_password_check');

        if ($this->form_validation->run() == FALSE) {
            $this->password();
        } else {
            $password = $this->input->post('password');
            $this->Login_Model->change_password($password);
            $this->password_changed();
        }
    }

    function password_changed() {
        
    }

    function register()
    {
        $this->load->view('login/register');
    }

    function update_password() {
        echo $this->Login_Model->update_password($this->input->post('data'));
    } 

    function view_profile()
    {
        
    }

}