<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require_once __DIR__ . '../../../vendor/autoload.php';

class Thendi extends CI_Controller {

	public function __construct()
    {
        parent::__construct();


        if (!$this->session->userdata('logged_in')) {
            redirect('/login');
        }
    }

    public function index()
    {
        $data['summary'] = $this->Dashboard_Model->summary();
        $data['receipts'] = $this->Dashboard_Model->receipts();
        $data['transfers'] = $this->Dashboard_Model->transfers();
        $this->load->view('dashboard/index',$data);
    }

    public function receipts()
    {
        $data['module'] = 'Receipts';
        $data['tillnumber'] = $this->input->post('id');
        $data['tillnumbers'] = $this->Dashboard_Model->tillnumbers();
        $this->load->view('receipts/index',$data);
    } 

    public function transfers()
    {
        $data['module'] = 'Transfers';
        $data['tillnumber'] = $this->input->post('id');
        $data['tillnumbers'] = $this->Dashboard_Model->tillnumbers();
        $this->load->view('transfers/index',$data);
    }

    public function reports()
    {
        $data['module'] = 'Transfers';
        $data['tillnumbers'] = $this->Dashboard_Model->tillnumbers();
        $this->load->view('reports/index',$data);
    }

    public function print_receipts()
    {
        $post = $this->input->post();
                
        $mode = $post['report_type'];
        $date_from = $post['date_from'];
        $date_to = $post['date_to'];
        $tillnumber = $post['tillnumber'];

        if ($mode == 'PREVIEW') {
            $report =  $this->Dashboard_Model->receipts_($date_from,$date_to,$tillnumber,0);
            $data['mode'] = $mode;
            $data['data'] = $report['data'];
            $data['report_title'] = 'RECEIPTS';
            $this->load->view('print/report',$data);
        } else if ($mode == 'PDF') {
            $report = $this->Dashboard_Model->receipts_($date_from,$date_to,$tillnumber,0);
            $data['mode'] = $mode;
            $data['data'] = $report['data'];
            $data['report_title'] = 'RECEIPTS';
            $html = $this->load->view('print/report',$data,true);
            $pdfFilePath = "report.pdf";
            $mpdf = new \Mpdf\Mpdf();
            $mpdf->WriteHTML($html);
            $mpdf->Output($pdfFilePath, "D");
        } else {
            $report = $this->Dashboard_Model->receipts_($date_from,$date_to,$tillnumber,1);
            $data = $report['data'];
            $name = 'report.csv';
            force_download($name,$data);
        }
    }

    public function print_transfers()
    {
        $post = $this->input->post();
                
        $mode = $post['report_type'];
        $date_from = $post['date_from'];
        $date_to = $post['date_to'];
        $tillnumber = $post['tillnumber'];

        if ($mode == 'PREVIEW') {
            $report =  $this->Dashboard_Model->transfers_($date_from,$date_to,$tillnumber,0);
            $data['mode'] = $mode;
            $data['data'] = $report['data'];
            $data['report_title'] = 'TRANSFERS';
            $this->load->view('print/transfers',$data);
        } else if ($mode == 'PDF') {
            $report = $this->Dashboard_Model->transfers_($date_from,$date_to,$tillnumber,0);
            $data['mode'] = $mode;
            $data['data'] = $report['data'];
            $data['report_title'] = 'TRANSFERS';
            $html = $this->load->view('print/report',$data,true);
            $pdfFilePath = "transfers.pdf";
            $mpdf = new \Mpdf\Mpdf();
            $mpdf->WriteHTML($html);
            $mpdf->Output($pdfFilePath, "D");
        } else {
            $report = $this->Dashboard_Model->transfers_($date_from,$date_to,$tillnumber,1);
            $data = $report['data'];
            $name = 'report.csv';
            force_download($name,$data);
        }
    }

    public function today_receipts()
    {
        $mode = 'PREVIEW';//$this->input->post('mode');
        $data['mode'] = $mode;
        if ($mode == 'PREVIEW') {
            $report =  $this->Dashboard_Model->today_receipts(0);
            $data['data'] = $report['data'];
            $data['report_title'] = 'TODAYS RECEIPTS';
            $this->load->view('print/today_receipts',$data);
        } else if ($mode == 'PDF') {
            $report = $this->Dashboard_Model->today_receipts(0);
            $data['data'] = $report['data'];
            $data['report_title'] = 'TODAYS RECEIPTS';
            $html = $this->load->view('print/today_receipts',$data,true);
            $pdfFilePath = "today_summary.pdf";
            $mpdf = new \Mpdf\Mpdf();
            $mpdf->WriteHTML($html);
            $mpdf->Output($pdfFilePath, "D");
        } else {
            $report = $this->Dashboard_Model->today_receipts(1);
            $data = $report['data'];
            $name = 'today_receipts.csv';
            force_download($name,$data);
        }
    }

    public function today_summary()
    {
        $mode = 'PREVIEW';//$this->input->post('mode');
        $data['mode'] = $mode;
        if ($mode == 'PREVIEW') {
            $report =  $this->Dashboard_Model->today_summary(0);
            $data['data'] = $report['data'];
            $data['report_title'] = 'TODAYS RECEIPTS';
            $this->load->view('print/today_summary',$data);
        } else if ($mode == 'PDF') {
            $report = $this->Dashboard_Model->today_summary(0);
            $data['data'] = $report['data'];
            $data['report_title'] = 'TODAYS RECEIPTS';
            $html = $this->load->view('print/today_summary',$data,true);
            $pdfFilePath = "today_summary.pdf";
            $mpdf = new \Mpdf\Mpdf();
            $mpdf->WriteHTML($html);
            $mpdf->Output($pdfFilePath, "D");
        } else {
            $report = $this->Dashboard_Model->today_summary(1);
            $data = $report['data'];
            $name = 'today_summary.csv';
            force_download($name,$data);
        }
    }

    public function rpt()
    {

        $dat = $this->input->post('data');
        $mode = $this->input->post('mode');

        $data['report_title'] = 'MPESA TRANSACTIONS';
        $data['mode'] = $mode;

        if ($mode == 'PREVIEW') {
            $report =  $this->Dashboard_Model->rpt($dat,0);
            $data['data'] = $report['data'];
            $data['report_title'] = 'Report';
            $this->load->view('print/report',$data);
        } else if ($mode == 'PDF') {
            $report = $this->Dashboard_Model->rpt($dat,0);
            $data['data'] = $report['data'];
            $data['report_title'] = 'Report';
            $html = $this->load->view('print/report',$data,true);
            $pdfFilePath = "rpt.pdf";
            $mpdf = new \Mpdf\Mpdf();
            $mpdf->WriteHTML($html);
            $mpdf->Output($pdfFilePath, "D");
        } else {
            $report = $this->Dashboard_Model->rpt($dat,1);
            $data = $report['data'];
            $name = 'rpt.csv';
            force_download($name,$data);
        }
    }

    public function receipts_list()
    {
        function actions($q) {
             $chek = '
                <div class="dropdown">
                    <button class="btn btn-warning dropdown-toggle" type="button" data-toggle="dropdown">Actions
                    <span class="caret"></span></button>
                    <ul class="dropdown-menu">
                      <li><a href="#"class="list_actions" module="audit_trail"  
                        idx="'.$q->id.'" code="'.$q->id.'"
                        action="view">View</a></li>
                    </ul>
                  </div>
            ';

            return $chek;                    

        }

        function dt($d)
        {
            return substr($d, 6,2).'/'.substr($d, 4,2).'/'.substr($d, 0,4);
        }

        function tm($d)
        {
            //return substr($d, 8,14);
            return substr($d, 8,2).':'.substr($d, 10,2).':'.substr($d, 12,2);
        }

        $requestData = $_REQUEST;

        $query = $this->Dashboard_Model->receipts_list($requestData,$totalData,$totalFiltered,$total);

        $data = array();
        foreach ($query as $q) {
            $nestedData = array(); 

            $nestedData[] = $q->id;
            $nestedData[] = $q->TransID;
            $nestedData[] = $q->BusinessShortCode;
            $nestedData[] = $q->First_Name.' '.$q->Middle_Name.' '.$q->Last_Name;
            $nestedData[] = $q->MSISDN;
            $nestedData[] = number_format($q->TransAmount);
            #$nestedData[] = '<span style="text-align:right;">'.number_format($q->TransAmount).'</span>';
            $nestedData[] = dt($q->TransTime);
            $nestedData[] = tm($q->TransTime);
            $nestedData[] = number_format($q->OrgAccountBalance);
            $nestedData[] = actions($q);
            
            $data[] = $nestedData;
        }

        $json_data = array(
            "draw"            => intval( $requestData['draw'] ),   
            "recordsTotal"    => intval( $totalData ),  
            "recordsFiltered" => intval( $totalFiltered ),
            "data"            => $data,
            "total"   => 'Kshs '.number_format($total)  
        );

        echo json_encode($json_data);
    }

    public function transfers_list()
    {
        function actions($q) {
             $chek = '
                <div class="dropdown">
                    <button class="btn btn-warning dropdown-toggle" type="button" data-toggle="dropdown">Actions
                    <span class="caret"></span></button>
                    <ul class="dropdown-menu">
                      <li><a href="#"class="list_actions" module="audit_trail"  
                        idx="'.$q->id.'" code="'.$q->id.'"
                        action="view">View</a></li>
                    </ul>
                  </div>
            ';

            return $chek;                    

        }

        function dt($d)
        {
            return substr($d, 6,2).'/'.substr($d, 4,2).'/'.substr($d, 0,4);
        }

        function tm($d)
        {
            //return substr($d, 8,14);
            return substr($d, 8,2).':'.substr($d, 10,2).':'.substr($d, 12,2);
        }

        $requestData = $_REQUEST;

        $query = $this->Dashboard_Model->transfers_list($requestData,$totalData,$totalFiltered,$total);
 
        $data = array();
        foreach ($query as $q) {
            $nestedData = array(); 

            $nestedData[] = $q->id;
            $nestedData[] = $q->TransID;
            $nestedData[] = $q->BusinessShortCode;
            $nestedData[] = $q->First_Name.' '.$q->Middle_Name.' '.$q->Last_Name;
            $nestedData[] = $q->MSISDN;
            $nestedData[] = number_format($q->TransAmount);
            #$nestedData[] = '<span style="text-align:right;">'.number_format($q->TransAmount).'</span>';
            $nestedData[] = dt($q->TransTime);
            $nestedData[] = tm($q->TransTime);
            $nestedData[] = number_format($q->OrgAccountBalance);
            $nestedData[] = actions($q);
            
            $data[] = $nestedData;
        }

        $json_data = array(
            "draw"            => intval( $requestData['draw'] ),   
            "recordsTotal"    => intval( $totalData ),  
            "recordsFiltered" => intval( $totalFiltered ),
            "data"            => $data,
            "total"   => 'Kshs '.number_format($total)  
        );

        echo json_encode($json_data);
    }

}
