<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Payments extends CI_Controller {

	public function index1()
	{
		$this->load->view('index/index');
	} 
	
	public function index()
	{
	    $ref = $this->input->post('ref');
	    if($ref=='') $ref = 'PBA7IS0D03';
	    echo $this->Payments_Model->payments_json($ref);
	}
	 
    public function validation()
    {
        header("Content-Type:application/json");
        $PhoneNumber = '+254722320986';
	    //$this->Messaging_Model->send_sms($PhoneNumber,'Epic Savanna Green passes our greetings; FOR BEST QUALITY HONEY CALL +254728821081');
        echo '{"ResultCode":0,"ResultDesc":"Validation received successfully"}';
    }    
    
    public function confirmation()
    {
        header("Content-Type:application/json");
        $request=file_get_contents('php://input'); 
        if (!$request)
        {
            echo '{"ResultCode":1,"ResultDesc":"Invalid Input"}';
            #exit();
        }else{
            $this->Payments_Model->confirmation($request);
            echo '{"ResultCode":0,"ResultDesc":"Confirmation received successfully"}';
        }
        
    }
    
	public function validate_repayment()
	{
	    try
        {
            header("Content-Type:application/json");
            $resp = '{"ResultCode":0,"ResultDesc":"Validation passed successfully"}';
            $postData = file_get_contents('php://input');
            $filePath = "/home2/honeycok/public_html/apps/logs/validate_admin.txt";
            $errorLog = "/home2/honeycok/public_html/apps/logs/errors.txt";
            $file = fopen($filePath,"a");
            fwrite($file, $postData);
            fwrite($file,"\r\n");
            fwrite($file,$resp);
            fclose($file);

            $this->log_mpesa_stk_push($postData);
        } catch (Exception $ex){
            $logErr = fopen($errorLog,"a");
            fwrite($logErr, $ex->getMessage());
            fwrite($logErr,"\r\n");
            fclose($logErr);
            
            $resp = '{"ResultCode": 1, "ResultDesc":"Validation failure due to internal service error"}';
        }
        echo $resp;
    }
    
    public function confirm_repayment()
    {
        try
        {
            header("Content-Type:application/json");
            $resp = '{"ResultCode":0,"ResultDesc":"Confirmation received successfully"}';
            $postData = file_get_contents('php://input');
            $filePath = "/home2/honeycok/public_html/apps/logs/confirm.txt";
            $errorLog = "/home2/honeycok/public_html/apps/logs/errors.txt";
            $file = fopen($filePath,"a");
            fwrite($file, $postData);
            fwrite($file,"\r\n");
            fwrite($file,$resp);
            fclose($file);
            
            $this->log_mpesa_stk_push($postData);
        } catch (Exception $ex){
            $logErr = fopen($errorLog,"a");
            fwrite($logErr, $ex->getMessage());
            fwrite($logErr,"\r\n");
            fclose($logErr);
        }
            echo $resp;
    }
    
    public function log_mpesa_stk_push($request)
    {
        $request = json_decode($request);
        $request = $request->Result;
        
        $MerchantRequestID = $request->TransactionID;
        $CheckoutRequestID = $request->ConversationID;
        $ResultCode = $request->ResultCode;
        $ResultDesc = $request->ResultDesc;
        $CallbackMetadata = $request->ResultParameters->ResultParameter;
        
        foreach ($CallbackMetadata as $c) {
            if (isset($c->Value)) {
                $key = $c->Key;
                $value = $c->Value;
                if ($key == 'TransactionAmount') {$Amount = $value;}
                if ($key == 'TransactionReceipt') {$MpesaReceiptNumber = $value;}
                if ($key == 'TransactionCompletedDateTime') {$TransactionDate = $value;}
                if ($key == 'ReceiverPartyPublicName') {$PhoneNumber = $value;}
                if ($key == 'B2CUtilityAccountAvailableFunds') {$balance = $value;}
            }
        }    
        
        $this->log_mpesa_stk_push_($PhoneNumber,$MpesaReceiptNumber,$TransactionDate,$Amount,$balance);  
    }
    
    public function log_mpesa_stk_push_($PhoneNumber,$MpesaReceiptNumber,$TransactionDate,$Amount,$balance)
    {
        $phone = trim(substr($PhoneNumber,0,strpos($PhoneNumber,'-',1)-1));
        $name = trim(substr($PhoneNumber,strpos($PhoneNumber,'-',1)+1),100);

        $sql="INSERT INTO mpesa_payments
        ( 
            TransactionType,
            TransTime,
            TransID,
            TransAmount,
            BillRefNumber,
            MSISDN,
            First_Name,
            OrgAccountBalance
        ) VALUES  
        ( 
            'Loan Disbursal', 
            '$TransactionDate', 
            '$MpesaReceiptNumber',
            '$Amount', 
            '$MpesaReceiptNumber',
            '$phone',
            '$name',
            '$balance'
        )";
        
        $this->db->query($sql);
    }
    
    public function register()
    {
    	echo $this->Daraja_Model->register_url();
    }
    
    public function thankyou()
    {
        $tel = $this->uri->segment(3);
        echo $tel;
    }
}
